/*
 * $Id: EmptyIcon.java 65760 2007-07-25 18:10:46Z clinio $
 */

package tecgraf.javautils.gui;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;

/**
 * Imagem "vazia" (transparente). No desenha efetivamente nada, apenas reporta
 * as dimenses especificadas no construtor. Ideal para criar p.ex. espaos para
 * alinhamento de itens de menu.
 * 
 * @author Tecgraf/PUC-Rio
 */
class EmptyIcon implements Icon {

  /**
   * Largura
   */
  private final int width;

  /**
   * Altura
   */
  private final int height;

  /**
   * Construtor padro
   * 
   * @param width largura
   * @param height altura
   */
  EmptyIcon(int width, int height) {
    this.width = width;
    this.height = height;
  }

  /**
   * {@inheritDoc}
   */
  public int getIconHeight() {
    return height;
  }

  /**
   * {@inheritDoc}
   */
  public int getIconWidth() {
    return width;
  }

  /**
   * {@inheritDoc}
   * 
   * Sem implementao (cdigo vazio)
   */
  public void paintIcon(Component c, Graphics g, int x, int y) {
    // vazio
  }

}
