package tecgraf.javautils.gui.selector;

import java.util.*;
/**
 * <p>Description: Evento gerado pelo ItemContainer quando um elemento 
 * selecionado</p>
 */
public class ItemContainerEvent <T> extends EventObject {

  private Collection<T> selectedElements;

  /**
   * Cria um IemContainerEvent
   *
   * @param source ItemContainer responsavel pela gerao do evento
   * @param selectedElements Collection elementos selecionados
   */
  public ItemContainerEvent(ItemContainer<T> source,
      Collection<T> selectedElements) {
    super(source);
    this.selectedElements = new LinkedList<T>(selectedElements);
  }

  /**
   * Pega os elementos selecionados
   *
   * @return Collection com os elementos selecionados, sendo esta coleo no
   * modificavel ({@link Collections#unmodifiableCollection(Collection)})
   */
  public Collection<T> getSelectedItens(){
    return Collections.unmodifiableCollection(this.selectedElements);
  }
}
