/*
 * $Id: RowHeaderTablePane.java 123606 2011-10-27 19:46:28Z giovani $
 */
package tecgraf.javautils.gui.table;

import java.util.List;

import javax.swing.JScrollPane;
import javax.swing.JTable;

/**
 * Classe que define um painel com uma tabela com um header de linha.
 */
public class RowHeaderTablePane extends JScrollPane {
  /** Lista apresentada como header */
  private RowHeader rowHeader;

  /**
   * Construtor de tabelas com header de linha.
   * 
   * @param table tabela a ser inserida no painel.
   * @param rowNames lista com os ttulos das linhas.
   */
  public RowHeaderTablePane(JTable table, List<? extends Object> rowNames) {
    this(table, rowNames, "");
  }

  /**
   * Construtor de tabelas com header de linha e com um ttulo acima do header.
   * 
   * @param table tabela a ser inserida no painel.
   * @param rowNames lista com os ttulos das linhas.
   * @param rowHeaderTitle ttulo para o header de linha.
   */
  public RowHeaderTablePane(JTable table, List<? extends Object> rowNames,
    String rowHeaderTitle) {
    super(table);
    buildRowHeader(table, rowNames, rowHeaderTitle);
  }

  /**
   * Altera os ttulos do header de linha da tabela.
   * 
   * @param rowNames novos ttulos do header de linha
   */
  public void setRowNames(List<? extends Object> rowNames) {
    rowHeader.setRowNames(rowNames);
  }

  /**
   * Cria o header de linha para a tabela com a lista de ttulos.
   * 
   * @param table tabela a ser inserida no painel.
   * @param rowNames lista com os ttulos das linhas.
   * @param rowHeaderTitle ttulo para o header de linha.
   */
  private void buildRowHeader(JTable table, List<? extends Object> rowNames,
    String rowHeaderTitle) {
    rowHeader = new RowHeader(this, table, rowNames, rowHeaderTitle);
    setRowHeaderView(rowHeader);
  }

  /**
   * Define os tooltips que devem ser apresentados na row header, para cada
   * linha.
   * 
   * @param tooltips uma lista com os tooltips que devem ser apresentados para
   *        cada linha. Se alguma linha no estiver contida na lista, no ser
   *        exibido nenhum tooltip nela. Se a lista for <code>null</code>,
   *        nenhum tooltip ser exibido.
   */
  public void setRowHeaderTooltips(List<String> tooltips) {
    rowHeader.setRowHeaderTooltips(tooltips);
  }
}
