/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

public enum OS {
    WINDOWS,
    LINUX,
    MAC,
    SOLARIS;


    public String getRootInstallDirVariable() {
        String rootInstallDir = null;
        if (this.equals((Object)WINDOWS)) {
            rootInstallDir = System.getenv("APPDATA");
            if (rootInstallDir == null) {
                throw new IllegalStateException("Vari\u00e1vel APPDATA n\u00e3o configurada");
            }
            return rootInstallDir;
        }
        if (this.equals((Object)LINUX) || this.equals((Object)MAC)) {
            rootInstallDir = System.getProperty("user.home");
            if (rootInstallDir == null) {
                throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o home do usu\u00e1rio utilizando a vari\u00e1vel user.home.");
            }
            return rootInstallDir;
        }
        throw new IllegalStateException("OS n\u00e3o suportado: " + this.name());
    }

    public static OS getOS() {
        String operSys = System.getProperty("os.name").toLowerCase();
        if (operSys != null) {
            if (operSys.contains("win")) {
                return WINDOWS;
            }
            if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
                return LINUX;
            }
            if (operSys.contains("mac")) {
                return MAC;
            }
            if (operSys.contains("sunos")) {
                return SOLARIS;
            }
        }
        return null;
    }
}

