/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.bind.DatatypeConverter;
import mslinks.ShellLink;
import tecgraf.javautils.launcher.LoggerFormatter;
import tecgraf.javautils.launcher.OS;
import tecgraf.javautils.launcher.SplashScreen;

public abstract class Launcher {
    public static final String WINDOWS_DESKTOP = "Desktop";
    public static final String PROTOCOL_VERSION = "3";
    public static final String PROTOCOL_VERSION_PROPERTY = "protocolVersion";
    public static final String WRONG_PROTOCOL_VERSION_MESSAGE_PROPERTY = "wrongProtocolVersionMesssage";
    public static final String SUCCESSFUL_SHORTCUT_CREATE_MESSAGE_PROPERTY = "successfulShortCutCreateMessage";
    public static final String SHORTCUT_CREATE_MESSAGE_PROPERTY = "shortCutCreateMessage";
    public static final String SHORTCUT_CREATE_ERROR_MESSAGE_PROPERTY = "shortcutCreateErrorMessage";
    public static final String LAUNCHER_FILE_NAME_PROPERTY = "launcherFileName";
    public static final String SPLASH_SCREEN_CLASS = "splashScreenClass";
    public static final String LAUNCHER_PROPERTIES_FILE = "launcher.properties";
    public static final String APP_JAR_FILE = "app.jar";
    public static final String APP_JAR_MD5_FILE = "app.jar.md5";
    public static final int REQUIRED_PRE_LAUNCHER_ARGS_SIZE = 2;
    public static final int MINIMAL_LAUNCHER_ARGS_SIZE = 5;
    public static final String APP_VISIBLE_MARKER = "APP-VISIBLE";
    public static final int DEFAULT_DEBUG_PORT = 5000;
    private static final String LAUNCHER_PREFIX = "launcher.";
    private static final String APP_PREFIX = "app.";
    protected static final Logger logger = Logger.getLogger("Logger");
    private static final String MODE_PRELAUNCHER = "prelauncher";
    private static final String MODE_PRELAUNCHER_CACHED = "prelauncher-cached";
    private static final String MODE_PRELAUNCHER_DEBUG = "prelauncher-debug";
    private static final String MODE_LAUNCHER = "launcher";
    private static final String MODE_LAUNCHER_DEBUG = "launcher-debug";
    private static final String APP_EXE_ERROR_MSG = "Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ";
    private static final String JAR_SUFFIX = ".jar";
    private String launcherPropertiesUrl;
    private Properties launcherProperties;
    private Properties versionProperties;
    private static final String[] JAR_CMD = new String[]{"java", "-jar"};

    protected abstract String getApplicationAcronym();

    protected abstract String getAppURL();

    private String getDownloadURL(String appURL) {
        if (!appURL.endsWith("/")) {
            appURL = appURL + '/';
        }
        return appURL + MODE_LAUNCHER + '/';
    }

    protected String getServerURL(String environment) {
        return this.getLauncherProperty("serverHost." + environment);
    }

    protected String getServerURL() {
        return this.getServerURL(this.getDefaultEnvironment());
    }

    protected abstract String getDefaultEnvironment();

    protected String getWindowsCurrentUserDesktopPath() {
        return System.getenv("userprofile") + "/" + WINDOWS_DESKTOP;
    }

    protected int getDebugPort() {
        return 5000;
    }

    protected void loadVersionProperties() {
        this.versionProperties = new Properties();
        try {
            this.versionProperties.load(Launcher.class.getResourceAsStream("/version.properties"));
        }
        catch (Exception e) {
            logger.severe("N\u00e3o foi poss\u00edvel carregar o arquivo de vers\u00e3o:" + e.getMessage());
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel carregar o arquivo de vers\u00e3o", e);
        }
    }

    protected abstract String getLinkName();

    public void start(String[] args) throws Exception {
        logger.info("start: " + Arrays.toString(args));
        this.loadVersionProperties();
        if (args.length > 0 && args[0].equalsIgnoreCase("version")) {
            logger.info("launcher version: " + this.versionProperties.getProperty("version"));
            System.exit(0);
        }
        boolean createShortcut = false;
        if (args.length == 0) {
            args = new String[]{MODE_PRELAUNCHER, this.getAppURL(), this.getDefaultEnvironment()};
            createShortcut = true;
        }
        String firstArg = args[0];
        String[] otherArgs = Arrays.copyOfRange(args, 1, args.length);
        if (firstArg.equalsIgnoreCase(MODE_PRELAUNCHER)) {
            this.startPreLauncher(false, false, createShortcut, otherArgs);
        } else if (firstArg.equalsIgnoreCase(MODE_PRELAUNCHER_CACHED)) {
            this.startPreLauncher(false, true, createShortcut, otherArgs);
        } else if (firstArg.equalsIgnoreCase(MODE_PRELAUNCHER_DEBUG)) {
            this.startPreLauncher(true, false, createShortcut, otherArgs);
        } else if (firstArg.equalsIgnoreCase(MODE_LAUNCHER)) {
            this.startLauncher(false, otherArgs);
        } else if (firstArg.equalsIgnoreCase(MODE_LAUNCHER_DEBUG)) {
            this.startLauncher(true, otherArgs);
        } else {
            logger.severe("A\u00e7\u00e3o n\u00e3o reconhecida: " + firstArg);
            this.error("A\u00e7\u00e3o n\u00e3o reconhecida: " + firstArg);
        }
    }

    public void startPreLauncher(boolean debug, boolean cached, boolean createShortcut, String[] args) {
        block35: {
            SplashScreen splashScreen = null;
            try {
                splashScreen = this.buildSplashScreen();
                splashScreen.setResizable(false);
                splashScreen.pack();
                splashScreen.setLocationRelativeTo(null);
                splashScreen.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                if (!cached) {
                    logger.info("Atualizando launcher e aplica\u00e7\u00e3o");
                    splashScreen.setMessage("Atualizando a aplica\u00e7\u00e3o...");
                } else {
                    logger.info("Executando launcher e aplica\u00e7\u00e3o do cache local");
                    splashScreen.setMessage("Executando a aplica\u00e7\u00e3o...");
                }
                splashScreen.setProgressBarIndeterminate(true);
                splashScreen.setVisible(true);
                OS os = OS.getOS();
                if (os == null) {
                    throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o nome do sistema operacional.");
                }
                Path rootInstallDir = Paths.get(os.getRootInstallDirVariable(), new String[0]);
                if (!Files.exists(rootInstallDir, new LinkOption[0])) {
                    throw new IllegalStateException("Diret\u00f3rio raiz inexistente: " + rootInstallDir.toString());
                }
                switch (os) {
                    case WINDOWS: {
                        rootInstallDir = rootInstallDir.resolve(this.getApplicationAcronym());
                        break;
                    }
                    case LINUX: 
                    case MAC: {
                        rootInstallDir = rootInstallDir.resolve("." + this.getApplicationAcronym());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("OS n\u00e3o suportado: " + os.name());
                    }
                }
                if (!Files.exists(rootInstallDir, new LinkOption[0])) {
                    Files.createDirectory(rootInstallDir, new FileAttribute[0]);
                }
                String preLauncherLogPath = rootInstallDir.resolve("pre_launcher.log").toString();
                String launcherLogPath = rootInstallDir.resolve("launcher.log").toString();
                logger.setUseParentHandlers(false);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new LoggerFormatter());
                logger.addHandler(consoleHandler);
                FileHandler fileHandler = new FileHandler(preLauncherLogPath);
                fileHandler.setFormatter(new LoggerFormatter());
                logger.addHandler(fileHandler);
                logger.info("launcher version: " + this.versionProperties.getProperty("version"));
                logger.info("preLauncher args: " + Arrays.toString(args));
                String javaVersion = System.getProperty("java.version");
                if (javaVersion == null) {
                    throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter a vers\u00e3o do Java");
                }
                logger.info("Java version: " + javaVersion);
                if (args.length >= 2) {
                    Process process;
                    String appJarFile;
                    String launcherJarFile;
                    String appURL = args[0];
                    String downloadURL = this.getDownloadURL(appURL);
                    if (!downloadURL.endsWith("/")) {
                        downloadURL = downloadURL + '/';
                    }
                    String environment = args[1].toLowerCase();
                    logger.info("environment: " + environment);
                    this.loadLauncherProperties(downloadURL);
                    String serverURL = this.getServerURL(environment).toLowerCase();
                    String protocolVersion = this.getLauncherProperty(PROTOCOL_VERSION_PROPERTY);
                    if (!PROTOCOL_VERSION.equals(protocolVersion)) {
                        String wrongInstallerVersionMesssage = this.getLauncherProperty(WRONG_PROTOCOL_VERSION_MESSAGE_PROPERTY);
                        splashScreen.dispose();
                        SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, wrongInstallerVersionMesssage, this.getApplicationAcronym(), 2));
                        System.exit(0);
                    }
                    String launcherFileName = this.getLauncherProperty(LAUNCHER_FILE_NAME_PROPERTY);
                    String launcherJarMD5URL = downloadURL + launcherFileName + ".md5";
                    String launcherJarURL = downloadURL + launcherFileName;
                    String launcherIconURL = downloadURL + this.getApplicationAcronym() + ".ico";
                    String appJarMD5URL = downloadURL + APP_JAR_MD5_FILE;
                    String appJarURL = downloadURL + APP_JAR_FILE;
                    if (createShortcut && os.equals((Object)OS.WINDOWS)) {
                        String shortcutFilename = this.getApplicationAcronym() + ".lnk";
                        Path shortcutPath = Paths.get(this.getWindowsCurrentUserDesktopPath(), new String[0]).resolve(shortcutFilename);
                        Path shortcutJar = rootInstallDir.resolve(this.getApplicationAcronym() + JAR_SUFFIX);
                        if (!shortcutPath.toFile().exists() && !shortcutJar.toFile().exists()) {
                            String shortcutCreateMessage = this.getLauncherProperty(SHORTCUT_CREATE_MESSAGE_PROPERTY);
                            splashScreen.setMessage(shortcutCreateMessage);
                            Path shortcutIco = rootInstallDir.resolve(this.getApplicationAcronym() + ".ico");
                            if (!cached) {
                                logger.info("[Windows shortcut] Atualizando cache do JAR e \u00edcone do launcher");
                                this.download(splashScreen, launcherJarURL, shortcutJar);
                                this.download(splashScreen, launcherIconURL, shortcutIco);
                            } else {
                                logger.info("[Windows shortcut] Usando JAR e \u00edcone do launcher do cache");
                                if (!shortcutJar.toFile().exists() || !shortcutIco.toFile().exists()) {
                                    throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-004");
                                }
                            }
                            ShellLink sl = ShellLink.createLink((String)shortcutJar.toString());
                            sl.setName(this.getLinkName());
                            sl.setIconLocation(shortcutIco.toString());
                            boolean error = false;
                            try {
                                sl.saveTo(shortcutPath.toString());
                            }
                            catch (Exception e) {
                                error = true;
                                logger.severe(e.getMessage());
                            }
                            splashScreen.dispose();
                            String message = error ? this.getLauncherProperty(SHORTCUT_CREATE_ERROR_MESSAGE_PROPERTY) : this.getLauncherProperty(SUCCESSFUL_SHORTCUT_CREATE_MESSAGE_PROPERTY);
                            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, message, this.getApplicationAcronym(), 1));
                            System.exit(0);
                        }
                    }
                    if (!Files.exists(rootInstallDir = rootInstallDir.resolve(environment), new LinkOption[0])) {
                        Files.createDirectory(rootInstallDir, new FileAttribute[0]);
                    }
                    if (!cached) {
                        logger.info("Atualizando JARs do launcher e da aplica\u00e7\u00e3o");
                        launcherJarFile = this.download(splashScreen, rootInstallDir, launcherJarMD5URL, launcherJarURL, LAUNCHER_PREFIX);
                        appJarFile = this.download(splashScreen, rootInstallDir, appJarMD5URL, appJarURL, APP_PREFIX);
                    } else {
                        logger.info("Usando c\u00f3pias locais dos JARs do launcher e da aplica\u00e7\u00e3o");
                        Path launcherJAR = this.getLastJAR(rootInstallDir, LAUNCHER_PREFIX);
                        if (launcherJAR == null) {
                            throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-006");
                        }
                        Path appJAR = this.getLastJAR(rootInstallDir, APP_PREFIX);
                        if (appJAR == null) {
                            throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-007");
                        }
                        launcherJarFile = launcherJAR.toString();
                        appJarFile = appJAR.toString();
                    }
                    splashScreen.setProgressBarIndeterminate(true);
                    splashScreen.dispose();
                    try {
                        ArrayList<String> params = new ArrayList<String>();
                        Collections.addAll(params, JAR_CMD);
                        params.add(launcherJarFile);
                        params.add(debug ? MODE_LAUNCHER_DEBUG : MODE_LAUNCHER);
                        params.add(launcherLogPath);
                        params.add(appJarFile);
                        params.add(appURL);
                        params.add(environment);
                        params.add(serverURL);
                        for (int i = 2; i < args.length; ++i) {
                            params.add(args[i]);
                        }
                        StringJoiner stringJoiner = new StringJoiner(" ");
                        for (String param : params) {
                            stringJoiner.add(param);
                        }
                        logger.info("Executando: " + stringJoiner.toString());
                        process = this.startPrelauncherProcess(params);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-001", e);
                    }
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-002", e);
                    }
                    if (process.exitValue() != 0) {
                        throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-003");
                    }
                    break block35;
                }
                throw new IllegalArgumentException("\u00c9 necess\u00e1rio informar ao menos a URL para o instalador do sistema e o nome do ambiente.");
            }
            catch (Exception e) {
                if (splashScreen != null) {
                    splashScreen.dispose();
                }
                this.logException(e);
                this.error(e.getMessage());
            }
        }
    }

    private Process startPrelauncherProcess(List<String> params) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.inheritIO();
        return builder.start();
    }

    protected void loadLauncherProperties(String host) {
        this.launcherPropertiesUrl = host + LAUNCHER_PROPERTIES_FILE;
        logger.info("launcherPropertiesUrl: " + this.launcherPropertiesUrl);
        this.launcherProperties = new Properties();
        try {
            URL url = new URL(this.launcherPropertiesUrl);
            this.launcherProperties.load(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel carregar o arquivo de propriedades: " + this.launcherPropertiesUrl, e);
        }
    }

    private void logException(Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            logger.severe(cause.getMessage());
            for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                logger.severe(stackTraceElement.toString());
            }
        }
    }

    protected void executeNewLauncher(String launcherJarFile, String appURL, String environment, String ... args) {
        Process process;
        try {
            ArrayList<String> params = new ArrayList<String>();
            Collections.addAll(params, JAR_CMD);
            params.add(launcherJarFile);
            params.add(MODE_PRELAUNCHER_CACHED);
            params.add(appURL);
            params.add(environment);
            Collections.addAll(params, args);
            StringJoiner stringJoiner = new StringJoiner(" ");
            for (String param : params) {
                stringJoiner.add(param);
            }
            logger.info("Executando: " + stringJoiner.toString());
            process = this.startPrelauncherProcess(params);
        }
        catch (Exception e) {
            throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-001", e);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-002", e);
        }
        if (process.exitValue() != 0) {
            throw new IllegalStateException("Ocorreu um erro ao executar a aplica\u00e7\u00e3o: ERROR-003");
        }
    }

    public void executeNewLauncher(String ... args) throws IOException {
        this.executeNewLauncher(this.getAppURL(), this.getDefaultEnvironment(), args);
    }

    public void executeNewLauncher(String appURL, String env, String ... args) throws IOException {
        this.executeNewLauncher(this.getInstalledLauncherJarFilename(env), appURL, env, args);
    }

    private String getInstalledLauncherJarFilename(String environment) throws IOException {
        OS os = OS.getOS();
        if (os == null) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o nome do sistema operacional.");
        }
        Path rootInstallDir = Paths.get(os.getRootInstallDirVariable(), new String[0]);
        if (!Files.exists(rootInstallDir, new LinkOption[0])) {
            throw new IllegalStateException("Diret\u00f3rio raiz inexistente: " + rootInstallDir.toString());
        }
        if (os.equals((Object)OS.WINDOWS)) {
            rootInstallDir = rootInstallDir.resolve(this.getApplicationAcronym());
        } else if (os.equals((Object)OS.LINUX) || os.equals((Object)OS.MAC)) {
            rootInstallDir = rootInstallDir.resolve("." + this.getApplicationAcronym());
        } else {
            throw new IllegalStateException("OS n\u00e3o suportado: " + os.name());
        }
        if (!Files.exists(rootInstallDir, new LinkOption[0])) {
            throw new IllegalStateException("Diret\u00f3rio inexistente: " + rootInstallDir.toString());
        }
        if (!Files.exists(rootInstallDir = rootInstallDir.resolve(environment), new LinkOption[0])) {
            throw new IllegalStateException("Diret\u00f3rio inexistente: " + rootInstallDir.toString());
        }
        List<Path> jarsInDirectory = this.getJARsInDirectory(rootInstallDir, LAUNCHER_PREFIX);
        if (jarsInDirectory.size() <= 0) {
            throw new IllegalStateException("App jar n\u00e3o localizado no diret\u00f3rio: " + rootInstallDir.toString());
        }
        Path jarFile = jarsInDirectory.get(jarsInDirectory.size() - 1);
        return jarFile.toString();
    }

    private List<Path> getJARsInDirectory(Path rootInstallDir, String prefix) throws IOException {
        return Files.list(rootInstallDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().startsWith(prefix)).filter(path -> path.getFileName().toString().toLowerCase().endsWith(JAR_SUFFIX)).sorted().collect(Collectors.toList());
    }

    private Path getLastJAR(Path dir, String prefix) throws IOException {
        List<Path> jars = this.getJARsInDirectory(dir, prefix);
        return jars.isEmpty() ? null : jars.get(jars.size() - 1);
    }

    private String download(SplashScreen splashScreen, Path rootInstallDir, String md5URL, String jarURL, String prefix) throws Exception {
        Path jarFile;
        List<Path> jarsInDirectory = this.getJARsInDirectory(rootInstallDir, prefix);
        if (jarsInDirectory.size() > 0) {
            logger.info("JAR localizado no diret\u00f3rio.");
            jarFile = jarsInDirectory.get(jarsInDirectory.size() - 1);
            logger.info("Obtendo MD5 de '" + md5URL + "'...");
            String correctMD5 = this.getMD5FromURL(md5URL);
            logger.info("MD5: " + correctMD5);
            logger.info("Gerando MD5 do JAR...");
            String md5Jar = this.getMD5(jarFile).toLowerCase();
            logger.info("MD5 do JAR: " + md5Jar);
            if (correctMD5.equals(md5Jar)) {
                logger.info("MD5 correto");
                return jarFile.toString();
            }
            logger.info("MD5s n\u00e3o s\u00e3o iguais");
        }
        if (jarsInDirectory.size() > 0) {
            logger.info("Apagando JARs antigos...");
            for (Path oldJar : jarsInDirectory) {
                try {
                    Files.delete(oldJar);
                }
                catch (Exception e) {
                    logger.info("Erro ao apagar o JAR: " + oldJar);
                }
            }
        }
        logger.info("Atualizando vers\u00e3o...");
        jarFile = rootInstallDir.resolve(prefix + System.currentTimeMillis() + JAR_SUFFIX);
        this.download(splashScreen, jarURL, jarFile);
        logger.info("Download do novo JAR realizado.");
        return jarFile.toString();
    }

    private String getLauncherProperty(String property) {
        String value = this.launcherProperties.getProperty(property);
        if (value == null) {
            throw new IllegalStateException("A propriedade " + property + " n\u00e3o foi definida no arquivo de properties: " + this.launcherPropertiesUrl);
        }
        return value;
    }

    protected void error(String message) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, message, "Erro", 0));
    }

    private void download(SplashScreen splashScreen, String fileURL, Path target) {
        URLConnection connection;
        try {
            URL url = new URL(fileURL);
            connection = url.openConnection();
        }
        catch (Exception e) {
            throw new IllegalStateException("Erro ao realizar download: " + fileURL, e);
        }
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(target.toFile()), 1024);){
            int x;
            splashScreen.setProgressBarIndeterminate(false);
            double completeFileSize = connection.getContentLength();
            byte[] data = new byte[1024];
            double downloadedFileSize = 0.0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                int currentProgress = (int)((downloadedFileSize += (double)x) / completeFileSize);
                splashScreen.setProgressBarValue(currentProgress);
                bout.write(data, 0, x);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Erro ao realizar download: " + fileURL, e);
        }
    }

    private String getMD5FromURL(String md5Url) {
        try {
            String inputLine;
            URL url = new URL(md5Url);
            URLConnection connection = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString().toLowerCase();
        }
        catch (Exception e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o md5: " + md5Url, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMD5(Path path) {
        try (FileInputStream fis = new FileInputStream(path.toFile());){
            int nread;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] dataBytes = new byte[1024];
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            String string = DatatypeConverter.printHexBinary((byte[])mdbytes);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel obter o md5: " + path.toString(), e);
        }
    }

    protected abstract List<String> buildParameters(String var1, String var2);

    private List<String> buildParameters(String appURL, String environment, String serverURL, String launcherVersion) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("--app_url " + appURL);
        params.add("--launcher_env " + environment);
        params.addAll(this.buildParameters(serverURL, launcherVersion));
        return params;
    }

    public void startLauncher(boolean debug, String[] args) throws Exception {
        SplashScreen splashScreen = this.buildSplashScreen();
        splashScreen.setMessage("Abrindo a aplica\u00e7\u00e3o...");
        splashScreen.setProgressBarIndeterminate(true);
        splashScreen.setResizable(false);
        splashScreen.pack();
        splashScreen.setLocationRelativeTo(null);
        splashScreen.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        splashScreen.setVisible(true);
        try {
            if (args.length < 5) {
                throw new IllegalArgumentException("Par\u00e2metros inv\u00e1lidos.");
            }
            String launcherLogPath = args[0];
            String appJarFile = args[1];
            String appURL = args[2];
            String environment = args[3];
            String serverURL = args[4];
            logger.setUseParentHandlers(false);
            FileHandler fileHandler = new FileHandler(launcherLogPath);
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new LoggerFormatter());
            logger.addHandler(fileHandler);
            logger.info("launcher version: " + this.versionProperties.getProperty("version"));
            logger.info("appJarFile: " + appJarFile);
            if (args.length == 5) {
                logger.info("Nenhum argumento recebido.");
            } else {
                logger.info("Argumentos recebidos:");
                for (int i = 5; i < args.length; ++i) {
                    logger.info("   " + args[i]);
                }
            }
            String launcherVersion = this.versionProperties.getProperty("version");
            ArrayList<String> params = new ArrayList<String>();
            Collections.addAll(params, JAR_CMD);
            if (debug) {
                params.add(String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=%d", this.getDebugPort()));
            }
            params.add(appJarFile);
            params.addAll(this.buildParameters(appURL, environment, serverURL, launcherVersion));
            for (int i = 5; i < args.length; ++i) {
                params.add(args[i]);
            }
            StringJoiner stringJoiner = new StringJoiner(" ");
            for (String param : params) {
                stringJoiner.add(param);
            }
            logger.info("Executando: " + stringJoiner.toString());
            ProcessBuilder builder = new ProcessBuilder(params);
            Process process = builder.start();
            StreamLogger errorReader = new StreamLogger(splashScreen, process.getErrorStream());
            errorReader.start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.equals(APP_VISIBLE_MARKER)) {
                        break;
                    }
                    logger.info("App output: " + line);
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logException(e);
            splashScreen.dispose();
            throw e;
        }
    }

    protected abstract SplashScreen buildSplashScreen();

    static class StreamLogger
    extends Thread {
        final SplashScreen splashScreen;
        final InputStream errorStream;

        StreamLogger(SplashScreen splashScreen, InputStream errorStream) {
            this.splashScreen = splashScreen;
            this.errorStream = errorStream;
        }

        @Override
        public void run() {
            boolean hasError = false;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.errorStream));){
                String line;
                while ((line = br.readLine()) != null) {
                    logger.severe(line);
                    hasError = true;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (hasError) {
                this.splashScreen.dispose();
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Ocorreu erro ao abrir a aplica\u00e7\u00e3o", "Erro", 0));
            }
        }
    }
}

