/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import tecgraf.javautils.launcher.Environment;

class Config {
    public final Environment environment;
    public final String appAcronym;
    public final String appName;
    public final List<String> desktopDirectories;
    public final String resourceIconName;
    public final String successShortcutMessage;
    public final String failureShortcutMessage;
    public final String successInstallMessage;
    public final String successInstallTitle;
    public final String requiredShortcutDirectory;
    public final String executeAppButtonText;
    public final String parametersChartset;

    public Config(String appAcronym, String appName, Environment environment, List<String> desktopDirectories, String resourceIconName, String successShortcutMessage, String failureShortcutMessage, String successInstallMessage, String successInstallTitle, String requiredShortcutDirectory, String executeAppButtonText, String parametersChartset) {
        this.environment = environment;
        this.appAcronym = appAcronym;
        this.appName = appName;
        this.desktopDirectories = desktopDirectories;
        this.resourceIconName = resourceIconName;
        this.successShortcutMessage = successShortcutMessage;
        this.failureShortcutMessage = failureShortcutMessage;
        this.successInstallMessage = successInstallMessage;
        this.successInstallTitle = successInstallTitle;
        this.requiredShortcutDirectory = requiredShortcutDirectory;
        this.executeAppButtonText = executeAppButtonText;
        this.parametersChartset = parametersChartset;
    }

    public static Config load(Logger logger) throws IOException {
        String line;
        logger.info("Carregando 'config.json'...");
        InputStream is = Config.class.getResourceAsStream("/config.json");
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        br.close();
        isr.close();
        is.close();
        JSONObject jsonObject = new JSONObject(sb.toString());
        String appAcronym = jsonObject.getString("appAcronym");
        logger.info("appAcronym: " + appAcronym);
        String defaultEnvironment = jsonObject.getString("defaultEnvironment");
        logger.info("defaultEnvironment: " + defaultEnvironment);
        Environment environment = null;
        JSONArray environments = jsonObject.getJSONArray("environments");
        for (int i = 0; i < environments.length(); ++i) {
            JSONObject env = environments.getJSONObject(i);
            String acronym = env.getString("acronym");
            if (!acronym.equals(defaultEnvironment)) continue;
            logger.info("Carregando propriedades do ambiente '" + defaultEnvironment + "' carregadas...");
            String name = Config.getStringFrom(logger, env, "name");
            String storageUrl = Config.getStringFrom(logger, env, "storageUrl");
            environment = new Environment(acronym, name, storageUrl);
            logger.info("Ambiente '" + defaultEnvironment + "' carregado.");
            break;
        }
        if (environment == null) {
            logger.severe(defaultEnvironment + " n\u00e3o localizado.");
            throw new IllegalStateException("Ambiente n\u00e3o localizado no config.json");
        }
        ArrayList<String> desktopDirectories = new ArrayList<String>();
        if (jsonObject.has("desktopDirectories")) {
            JSONArray desktopDirectoriesArray = jsonObject.getJSONArray("desktopDirectories");
            for (int i = 0; i < desktopDirectoriesArray.length(); ++i) {
                String dir = desktopDirectoriesArray.getString(i);
                logger.info(String.format("Diret\u00f3rio para atalho (%s): %s", i + 1, dir));
                desktopDirectories.add(dir);
            }
        }
        String appName = Config.getStringFrom(logger, jsonObject, "appName");
        String resourceIconName = Config.getStringFrom(logger, jsonObject, "resourceIconName");
        String successShortcutMessage = Config.getStringFrom(logger, jsonObject, "successShortcutMessage");
        String failureShortcutMessage = Config.getStringFrom(logger, jsonObject, "failureShortcutMessage");
        String successInstallMessage = Config.getStringFrom(logger, jsonObject, "successInstallMessage");
        String successInstallTitle = Config.getStringFrom(logger, jsonObject, "successInstallTitle");
        String requiredShortcutDirectory = Config.getStringFrom(logger, jsonObject, "requiredShortcutDirectory");
        String executeAppButtonText = Config.getStringFrom(logger, jsonObject, "executeAppButtonText");
        String parametersChartset = null;
        if (jsonObject.has("parametersChartset")) {
            parametersChartset = Config.getStringFrom(logger, jsonObject, "parametersChartset");
        }
        return new Config(appAcronym, appName, environment, Collections.unmodifiableList(desktopDirectories), resourceIconName, successShortcutMessage, failureShortcutMessage, successInstallMessage, successInstallTitle, requiredShortcutDirectory, executeAppButtonText, parametersChartset);
    }

    private static String getStringFrom(Logger logger, JSONObject jsonObject, String key) {
        String value = jsonObject.getString(key);
        logger.info(key + ": " + value);
        return value;
    }
}

