/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import mslinks.ShellLink;
import tecgraf.javautils.launcher.Base;
import tecgraf.javautils.launcher.Config;
import tecgraf.javautils.launcher.FileType;
import tecgraf.javautils.launcher.InstallerFrame;
import tecgraf.javautils.launcher.InstallerSuccessFrame;
import tecgraf.javautils.launcher.OS;
import tecgraf.javautils.launcher.SplashScreen;

public class Installer
extends Base {
    @Override
    protected void execute(String[] args, Config config, OS os) {
        Path defaultRootDirectory = this.getDefaultRootDirectory(os);
        Path defaultDesktopDirectory = this.getDefaultDesktopDirectory(config);
        InstallerFrame frame = new InstallerFrame(os, defaultRootDirectory, config, defaultDesktopDirectory, this.getIcon(), (rootDirectory, desktopInstallDir) -> {
            Path rootAppInstallDir = this.getRootAppDirectory(rootDirectory, config, os);
            Thread thread = new Thread(() -> this.install(rootAppInstallDir, desktopInstallDir, config, os));
            thread.start();
        });
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(Path rootAppInstallDir, Path desktopInstallDir, Config config, OS os) {
        logger.info("Instalando a aplica\u00e7\u00e3o");
        SplashScreen splashScreen = this.buildSplashScreen(config);
        if (splashScreen != null) {
            SwingUtilities.invokeLater(() -> {
                splashScreen.setMessage("Instalando a aplica\u00e7\u00e3o...");
                splashScreen.setProgressBarIndeterminate(true);
                splashScreen.setVisible(true);
            });
        }
        Path launcherPath = null;
        Path shortcutPath = null;
        boolean shortcutError = false;
        try {
            if (!Files.exists(rootAppInstallDir, new LinkOption[0])) {
                logger.info("Criando diret\u00f3rio: " + rootAppInstallDir);
                Files.createDirectory(rootAppInstallDir, new FileAttribute[0]);
            }
            this.setFileLogger(rootAppInstallDir.resolve("installer.log"));
            Path environmentInstallDir = rootAppInstallDir.resolve(config.environment.acronym);
            if (!Files.exists(environmentInstallDir, new LinkOption[0])) {
                logger.info("Criando diret\u00f3rio: " + environmentInstallDir);
                Files.createDirectory(environmentInstallDir, new FileAttribute[0]);
            }
            String storageRootUrl = config.environment.storageUrl;
            String iconName = config.appAcronym + ".ico";
            launcherPath = environmentInstallDir.resolve(FileType.LAUNCHER.filename());
            this.download(splashScreen, storageRootUrl + iconName, environmentInstallDir.resolve(iconName), 1);
            this.download(splashScreen, storageRootUrl + FileType.LAUNCHER.filename(), launcherPath, 2);
            this.download(splashScreen, storageRootUrl + FileType.APP.filename(), environmentInstallDir.resolve(FileType.APP.filenameWithTimestamp()), 3);
            this.download(splashScreen, storageRootUrl + FileType.PARAMETERS.filename(), environmentInstallDir.resolve(FileType.PARAMETERS.filenameWithTimestamp()), 4);
            if (os.equals((Object)OS.WINDOWS) && desktopInstallDir != null) {
                if (!Files.exists(desktopInstallDir, new LinkOption[0])) {
                    throw new IllegalStateException("Diret\u00f3rio para instalar atalho inexistente: " + desktopInstallDir);
                }
                String shortcutFilename = config.appAcronym + "-" + config.environment.acronym + ".lnk";
                shortcutPath = desktopInstallDir.resolve(shortcutFilename);
                ShellLink sl = ShellLink.createLink((String)launcherPath.toString());
                sl.setName(config.appName + " - " + config.environment.acronym);
                Path icoPath = environmentInstallDir.resolve(iconName);
                sl.setIconLocation(icoPath.toString());
                logger.info("Criando atalho: " + shortcutPath);
                try {
                    sl.saveTo(shortcutPath.toString());
                }
                catch (Exception e) {
                    shortcutError = true;
                    logger.log(Level.SEVERE, "Erro ao criar atalho", e.toString());
                }
            }
            if (splashScreen != null) {
                SwingUtilities.invokeLater(splashScreen::dispose);
            }
        }
        catch (Exception e) {
            this.logException(e);
            this.showErrorAndExit(e.getMessage());
        }
        finally {
            if (splashScreen != null) {
                SwingUtilities.invokeLater(splashScreen::dispose);
            }
        }
        Path finalLauncherPath = launcherPath;
        InstallerSuccessFrame frame = new InstallerSuccessFrame(config, this.getIcon(), launcherPath, shortcutPath, shortcutError, () -> this.onExecute(finalLauncherPath));
        SwingUtilities.invokeLater(() -> frame.setVisible(true));
    }

    private void download(SplashScreen splashScreen, String fileUrl, Path target, int current) {
        if (splashScreen != null) {
            SwingUtilities.invokeLater(() -> splashScreen.setMessage("Baixando arquivos (" + current + "/4)"));
        }
        this.download(splashScreen, fileUrl, target);
    }

    private Path getDefaultDesktopDirectory(Config config) {
        for (String desktopDirName : config.desktopDirectories) {
            Path desktopDirectory = Paths.get(this.getUserHome(), desktopDirName);
            if (desktopDirectory.toFile().exists()) {
                logger.info("Diret\u00f3rio default para atalho localizado: " + desktopDirectory);
                return desktopDirectory;
            }
            logger.info("Diret\u00f3rio para atalho inexistente: " + desktopDirectory);
        }
        return null;
    }

    protected Path getDefaultRootDirectory(OS os) {
        return Paths.get(this.getUserHome(), new String[0]);
    }

    protected final Path getRootAppDirectory(Path rootDirectory, Config config, OS os) {
        if (!Files.exists(rootDirectory, new LinkOption[0])) {
            throw new IllegalStateException("Diret\u00f3rio raiz inexistente: " + rootDirectory);
        }
        return os.resolvePath(rootDirectory, config.appAcronym);
    }

    private void onExecute(Path launcherPath) {
        ArrayList<String> params = new ArrayList<String>();
        Collections.addAll(params, JAR_CMD);
        params.add(launcherPath.toString());
        StringJoiner stringJoiner = new StringJoiner(" ");
        for (String param : params) {
            stringJoiner.add(param);
        }
        logger.info("Executando: " + stringJoiner);
        try {
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.directory(launcherPath.getParent().toFile());
            builder.start();
        }
        catch (Exception e) {
            this.logException(e);
            this.showErrorAndExit(e.getMessage());
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        Installer installer = new Installer();
        installer.start(args);
    }
}

