package tecgraf.javautils.pdfviewer.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;

/**
 * Ao de pgina anterior.
 * 
 * @author Tecgraf
 */
public class PDFPrevPageAction extends PDFAbstractPageChangeAction {
  /**
   * Construtor
   * 
   * @param pdfCorePanel painel bsico.
   */
  public PDFPrevPageAction(PDFCorePanel pdfCorePanel) {
    super(pdfCorePanel, PDFViewerImages.createImageIcon("prev.page.16.gif"));
    final KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0);
    putValue(Action.ACCELERATOR_KEY, ks);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final PDFCorePanel pdfPanel = getPDFCorePanel();
    if (pdfPanel.canGoToPrevPage()) {
      pdfPanel.goToPrevPage();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void pageChanged(int pageNum, int totalPages) {
    setEnabled(pageNum > 0 && totalPages > 1);
  }
}