package tecgraf.javautils.pdfviewer.viewer.actions;

import java.awt.event.ActionEvent;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.actions.PDFAbstractDocumentOpenAwareAction;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerPanel;

/**
 * Fechamento do documento.
 * 
 * @author Tecgraf
 */
public class PDFCloseAction extends PDFAbstractDocumentOpenAwareAction {

  /** {@link PDFViewerPanel} a ter o documento fechado */
  final private PDFViewerPanel pdfViewerPanel;

  /**
   * Construtor.
   * 
   * @param pdfCorePanel painel bsico
   * 
   * @param pdfViewerPanel painel do visualizador pdf
   */
  public PDFCloseAction(PDFCorePanel pdfCorePanel, PDFViewerPanel pdfViewerPanel) {
    super(pdfCorePanel, PDFViewerImages.createImageIcon("close.16.gif"));
    this.pdfViewerPanel = pdfViewerPanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    pdfViewerPanel.closePDF();
  }
}
