package tecgraf.javautils.pdfviewer.viewer.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

import tecgraf.javautils.pdfviewer.core.PDFDocument;
import tecgraf.javautils.pdfviewer.core.PDFReader;
import tecgraf.javautils.pdfviewer.dialog.PDFDialog;

/**
 * Demo do PDFViewer, deve-se passar um arquivo PDF como primeiro argumento
 * 
 * @author Tecgraf
 */
class PDFViewerDemo {
  /**
   * Main
   * 
   * @param args argumentos do demo
   * @throws IOException
   */
  public static void main(String[] args) throws IOException {
    if (args.length < 1) {
      System.err.println("Adicione um arquivo PDF como parmetro");
      System.exit(1);
    }

    File pdfFile = new File(args[0]);
    if (!pdfFile.exists() || !pdfFile.isFile()) {
      final String fmt = "Arquivo [%s] no existe!";
      final String path = pdfFile.getAbsolutePath();
      System.err.println(String.format(fmt, path));
      System.exit(1);
    }

    InputStream inStream = new FileInputStream(pdfFile);
    PDFDialog dialog = new PDFDialog(null, "Titulo", Locale.getDefault());
    PDFDocument document = new PDFReader().read(inStream);
    dialog.loadDocument(document);
    dialog.setVisible(true);
  }
}
