package tecgraf.javautils.pdfviewer.viewer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

/**
 * Bundle de internacionalizao do PDFViewer
 * 
 * @author Tecgraf
 */
public class PDFViewerBundle extends ResourceBundle {

  /**
   * Mapa de chave -> string internacionalizada
   */
  final private Properties properties = new Properties();

  /**
   * Monta path de resource.
   * 
   * @param locale locale
   * @return path
   */
  private static String getResourcePath(Locale locale) {
    final String dirName = "resources/bundles/";
    final String className = PDFViewerBundle.class.getSimpleName();
    final String name = locale.getLanguage() + "_" + locale.getCountry();
    final String resPath = dirName + className + "_" + name + ".properties";
    return resPath;
  }

  /**
   * Busca stream.
   * 
   * @param locale locale
   * @return stream apontando ao arquivo de bundle ou nulo se no existir
   */
  private static InputStream getResourceInputStream(Locale locale) {
    final String path = getResourcePath(locale);
    final InputStream stream = PDFViewerBundle.class.getResourceAsStream(path);
    return stream;
  }

  /**
   * Construtor
   * 
   * @param locale do bundle
   */
  public PDFViewerBundle(final Locale locale) {
    InputStream inputStream = getResourceInputStream(locale);
    if (inputStream != null) {
      try {
        properties.load(inputStream);
      }
      catch (IOException ex) {
        System.err.println(ex.getMessage());
      }
    }
    else {
      final String className = this.getClass().getName();
      final String msg =
        className + ": Arquivo de internacionalizao no encontrado: "
          + getResourcePath(locale);
      System.err.println(msg);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleGetObject(String key) {
    if (properties.containsKey(key)) {
      return properties.get(key);
    }
    else {
      return "<<" + key + ">>";
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Enumeration<String> getKeys() {
    final Set<String> keys = properties.stringPropertyNames();
    if (parent != null) {
      final Enumeration<String> parentKeys = parent.getKeys();
      if (parentKeys != null) {
        keys.addAll(Collections.list(parentKeys));
      }
    }
    final Enumeration<String> enumeration = Collections.enumeration(keys);
    return enumeration;
  }
}
