/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.core;

import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ThumbnailTableCellRenderer
extends DefaultTableCellRenderer {
    private final Dimension pageDimension;

    public ThumbnailTableCellRenderer(Dimension pageDimension) {
        this.pageDimension = pageDimension;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        PDFPage currentPage = (PDFPage)value;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, 0, column);
        if (this.pageDimension.width > 0 && this.pageDimension.height > 0) {
            label.setOpaque(true);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
            Image image = currentPage.getImage(this.pageDimension.width, this.pageDimension.height, null, null, true, true);
            ImageIcon imageIcon = new ImageIcon(image);
            int pageNumber = row + 1;
            label.setText("" + pageNumber);
            if (!isSelected) {
                label.setBackground(Color.GRAY);
            }
            label.setIcon(imageIcon);
        }
        return label;
    }
}

