/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFPageChangedListener;

class PageNumberPanel
extends JPanel
implements PDFPageChangedListener,
PDFDocumentOpenCloseListener,
ActionListener {
    static final String SEPARATOR = " / ";
    final JTextField currentPage = new JFormattedTextField(NumberFormat.getInstance());
    final JLabel totalPagesLabel = new JLabel(" / 0");
    final Dimension elementsMaxSize = new Dimension(50, 20);
    final Dimension elementsMinSize = new Dimension(20, 10);
    final PDFCorePanel pdfPanel;

    public PageNumberPanel(PDFCorePanel pdfPanel) {
        this.pdfPanel = pdfPanel;
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setEnabled(false);
        this.setMaximumSize(new Dimension(this.elementsMaxSize.width * 2, this.elementsMaxSize.height + 6));
        this.currentPage.setText("0");
        this.currentPage.setHorizontalAlignment(4);
        this.currentPage.setMinimumSize(this.elementsMinSize);
        this.currentPage.setPreferredSize(this.elementsMaxSize);
        this.currentPage.setMaximumSize(this.elementsMaxSize);
        this.totalPagesLabel.setMinimumSize(this.elementsMinSize);
        this.totalPagesLabel.setPreferredSize(this.elementsMaxSize);
        this.totalPagesLabel.setMaximumSize(this.elementsMaxSize);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.currentPage);
        this.add(this.totalPagesLabel);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.currentPage.addActionListener(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.currentPage.setEnabled(enabled);
        this.totalPagesLabel.setEnabled(enabled);
    }

    @Override
    public void pageChanged(int pageNum, int totalPages) {
        this.setCurrentPageNumber(pageNum + 1);
    }

    private void setCurrentPageNumber(int pageNum) {
        this.currentPage.setText("" + pageNum);
    }

    @Override
    public void documentOpened(PDFCorePanel source) {
        this.setEnabled(true);
        this.totalPagesLabel.setText(SEPARATOR + source.getTotalPageNumber());
    }

    @Override
    public void documentClosed(PDFCorePanel source) {
        this.setEnabled(false);
        this.currentPage.setText("0");
        this.totalPagesLabel.setText(" / 0");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.currentPage) {
            try {
                int pageNum = Integer.valueOf(this.currentPage.getText());
                if (pageNum > 0 && pageNum <= this.pdfPanel.getTotalPageNumber()) {
                    this.pdfPanel.setPage(pageNum - 1);
                } else {
                    this.setCurrentPageNumber(this.pdfPanel.getPageNumber() + 1);
                }
            }
            catch (NumberFormatException ex) {
                this.setCurrentPageNumber(this.pdfPanel.getPageNumber() + 1);
            }
        }
    }
}

