package tecgraf.javautils.pdfviewer.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import com.sun.pdfview.PDFPage;

/**
 * Renderizador de thumbnail (feito como tabela).
 * 
 * @author Tecgraf
 */
public class ThumbnailTableCellRenderer extends DefaultTableCellRenderer {

  /**
   * Referncia ao tamanho usado para a thumbnail
   */
  final private Dimension pageDimension;

  /**
   * Construtor.
   * 
   * @param pageDimension referncia imutvel do tamanho do thumbnail
   */
  public ThumbnailTableCellRenderer(Dimension pageDimension) {
    super();
    this.pageDimension = pageDimension;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {

    PDFPage currentPage = (PDFPage) value;

    JLabel label =
      (JLabel) super.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, 0, column);

    if (pageDimension.width > 0 && pageDimension.height > 0) {
      label.setOpaque(true);
      label.setVerticalAlignment(SwingConstants.CENTER);
      label.setHorizontalAlignment(SwingConstants.CENTER);
      label.setHorizontalTextPosition(SwingConstants.CENTER);
      label.setVerticalTextPosition(SwingConstants.BOTTOM);

      final Image image =
        currentPage.getImage(pageDimension.width, pageDimension.height, null,
          null, true, true);
      ImageIcon imageIcon = new ImageIcon(image);
      int pageNumber = row + 1;
      label.setText("" + pageNumber);

      if (!isSelected) {
        label.setBackground(Color.GRAY);
      }

      label.setIcon(imageIcon);
    }
    return label;
  }
}
