package tecgraf.javautils.sparkserver.demo;

import java.io.IOException;
import java.util.Date;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

import tecgraf.javautils.sparkserver.standard.JuWebSocketClass;

@WebSocket
public class PingWebSocket extends JuWebSocketClass {


  public PingWebSocket() {
    final TimerTask runnable = new TimerTask() {
      @Override
      public void run() {
        broadcastString("ping-pong");
      }
    };
    final Timer timer = new Timer();
    timer.schedule(runnable, 1000, 2000);
  }

  @Override
  public void connected(Session session) {
  }

  @Override
  public void closed(Session session, int statusCode, String reason) {
  }

  @Override
  public void messageReceived(Session session, String message) {
      sendString(session, message + " OK");
  }

}
