package tecgraf.javautils.sparkserver.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.core.JuIWebSocket;

public class JuController implements JuIController {

  private final List<JuIEndpoint> endpoints = new ArrayList<>();
  private final List<JuIWebSocket> websockets = new ArrayList<>();

  private String pathPrefix;

  protected JuController() {
  }

  @Override
  public String getPathPrefix() {
    return pathPrefix;
  }

  public void setPathPrefix(String pathPrefix) {
    if (pathPrefix != null) {
      if (pathPrefix.indexOf("/") != -1) {
        throw new IllegalArgumentException("path-prefix cannot contain '/'");
      }
    }
    this.pathPrefix = pathPrefix;
  }

  @Override
  public Stream<JuIEndpoint> getEndpoints() {
    return endpoints.stream();
  }

  public Stream<JuIWebSocket> getWebSockets() {
    return websockets.stream();
  }

  protected <T> void addEndpoint(JuVerb verb, String path, JuIFunction<T> function) {
    final String realPath = getRealPath(path);
    this.endpoints.add(new JuEndpoint(verb, realPath, function));
  }

  protected <T> void addWebSocket(String path, Class<? extends JuWebSocketClass> clazz) {
    final String realPath = getRealPath(path);
    this.websockets.add(new JuWebSocket(realPath, clazz));
  }

  private String getRealPath(String path) {
    final String prefix = getPathPrefix();
    final boolean noPath = path == null || path.trim().isEmpty();
    final boolean noPrefix = prefix == null || prefix.trim().isEmpty();
    if (noPath && noPrefix) return "/";
    if (noPath) return prefix;
    if (noPrefix) return path;
    return prefix + "/" + path;
  }
}
