package tecgraf.javautils.sparkserver.utils;

import java.io.IOException;
import java.io.StringWriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import spark.Request;
import spark.Response;

public class JuSparkUtilities {


  public static String getRequestParameter(Request request, String parameterName) {
    if (parameterName == null || parameterName.isEmpty()) {
      final String err = "parameter name cannot be null.";
      throw new IllegalArgumentException(err);
    }
    return request.params(parameterName);
  }

  public static String getHeaderParameter(Request request, String parameterName) {
    if (parameterName == null || parameterName.isEmpty()) {
      final String err = "parameter name cannot be null.";
      throw new IllegalArgumentException(err);
    }
    return request.headers(parameterName);
  }

  public static String getQueryParameter(Request request, String parameterName) {
    if (parameterName == null || parameterName.isEmpty()) {
      final String err = "parameter name cannot be null.";
      throw new IllegalArgumentException(err);
    }
    return request.queryParams(parameterName);
  }

  public static <T> String setResponseAsJson(Response response, int statusCode, T data) throws IOException {
    final String jsonString = objectToJson(data);
    response.type("application/json");
    response.body(jsonString);
    response.status(statusCode);
    return jsonString;
  }

  public static <T> T jsonToObject(String json, Class<T> clazz) throws IOException {
    final ObjectMapper objectMapper = new ObjectMapper();
    return objectMapper.readValue(json, clazz);
  }

  public static JsonNode jsonToNode(String json) throws IOException {
    final ObjectMapper objectMapper = new ObjectMapper();
    return objectMapper.readTree(json);
  }

  public static <T> String objectToJson(T data) throws IOException {
    final ObjectMapper mapper = new ObjectMapper();
    mapper.enable(SerializationFeature.INDENT_OUTPUT);
    final StringWriter sw = new StringWriter();
    mapper.writeValue(sw, data);
    return sw.toString();
  }

  public static String setResponseAsText(Response response, int statusCode, String message) {
    response.type("text/plain");
    response.body(message);
    response.status(statusCode);
    return message;
  }
}
