/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.core.JuIWebSocket;
import tecgraf.javautils.sparkserver.standard.JuEndpoint;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.standard.JuWebSocket;
import tecgraf.javautils.sparkserver.standard.JuWebSocketClass;

public class JuController
implements JuIController {
    private final List<JuIEndpoint> endpoints = new ArrayList<JuIEndpoint>();
    private final List<JuIWebSocket> websockets = new ArrayList<JuIWebSocket>();
    private String pathPrefix;

    protected JuController() {
    }

    @Override
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        if (pathPrefix != null && pathPrefix.indexOf("/") != -1) {
            throw new IllegalArgumentException("path-prefix cannot contain '/'");
        }
        this.pathPrefix = pathPrefix;
    }

    @Override
    public Stream<JuIEndpoint> getEndpoints() {
        return this.endpoints.stream();
    }

    @Override
    public Stream<JuIWebSocket> getWebSockets() {
        return this.websockets.stream();
    }

    protected <T> void addEndpoint(JuVerb verb, String path, JuIFunction<T> function) {
        String realPath = this.getRealPath(path);
        this.endpoints.add(new JuEndpoint(verb, realPath, function));
    }

    protected <T> void addWebSocket(String path, Class<? extends JuWebSocketClass> clazz) {
        String realPath = this.getRealPath(path);
        this.websockets.add(new JuWebSocket(realPath, clazz));
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private String getRealPath(String path) {
        boolean noPrefix;
        String prefix = this.getPathPrefix();
        boolean noPath = path == null || path.trim().isEmpty();
        boolean bl = noPrefix = prefix == null || prefix.trim().isEmpty();
        if (noPath && noPrefix) {
            return "/";
        }
        if (noPath) {
            return prefix;
        }
        if (noPrefix) {
            return path;
        }
        return prefix + "/" + path;
    }
}

