/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.standard;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Route;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.exceptions.JuException;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;

public class JuRoute<T>
implements Route {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JuIFunction<T> function;

    public JuRoute(JuIFunction<T> function) {
        if (function == null) {
            throw new IllegalArgumentException("null function not allowed!");
        }
        this.function = function;
    }

    public Object handle(Request request, Response response) throws Exception {
        String hashString = UUID.randomUUID().toString();
        try {
            this.logger.info(this.getLoggerId(">>", null, hashString, request.pathInfo()));
            T object = this.function.call(request, response);
            this.logger.info(this.getLoggerId("<<", 200, hashString, String.format("status %d", response.status())));
            return object;
        }
        catch (JuException e) {
            String err = e.getMessage();
            int statusCode = e.getStatusCode();
            this.logger.warn(this.getLoggerId("XX", statusCode, hashString, err));
            return JuResponseUtilities.setResponseAsText(response, statusCode, err);
        }
        catch (Throwable t) {
            String err = t.getMessage();
            int statusCode = 500;
            this.logger.error(this.getLoggerId("!!", 500, hashString, err), t);
            return JuResponseUtilities.setResponseAsText(response, 500, err);
        }
    }

    private String getLoggerId(String prefix, Integer statusCode, String hashString, String text) {
        if (statusCode == null) {
            return String.format("%s [%s]: %s", prefix, hashString, text);
        }
        return String.format("%s [%s] (%02d): %s", prefix, hashString, statusCode, text);
    }
}

