/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Route;
import spark.Service;
import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIWebSocket;
import tecgraf.javautils.sparkserver.standard.JuRoute;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.standard.JuWebSocketClass;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuSwaggerParser;

public class JuServer {
    private static JuServer instance;
    private final Service server;
    private final List<JuIController> controllers = new ArrayList<JuIController>();
    private final Logger logger = LoggerFactory.getLogger(JuServer.class);

    private JuServer() {
        this.server = Service.ignite();
        this.setPort(9999);
        this.setThreadsPool(5, 3, 3000);
    }

    public static JuServer getInstance() {
        if (instance == null) {
            instance = new JuServer();
        }
        return instance;
    }

    public void setThreadsPool(int maxThreads, int minThreads, int timeOutMillis) {
        this.server.threadPool(maxThreads, minThreads, timeOutMillis);
    }

    public void setPort(int port) {
        this.server.port(port);
    }

    public void setExceptionHandler(Consumer<Exception> consumer) {
        this.server.initExceptionHandler(consumer);
    }

    public void stop() {
        this.server.stop();
    }

    public void start() throws Exception {
        try {
            for (JuIController controller : this.controllers) {
                this.registerController(controller);
            }
            this.enableCORS();
        }
        catch (Throwable t) {
            this.server.stop();
            throw new Exception(t);
        }
        this.server.init();
        this.server.awaitInitialization();
    }

    public void addController(JuIController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("null controller not allowed!");
        }
        this.controllers.add(controller);
    }

    private void enableCORS() {
        this.enableCORS("*", "*", "*");
    }

    private void enableCORS(String origin, String methods, String headers) {
        this.server.options("/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        this.server.before((request, response) -> {
            response.header("Access-Control-Allow-Origin", origin);
            response.header("Access-Control-Request-Method", methods);
            response.header("Access-Control-Allow-Headers", headers);
            response.type("application/json");
        });
    }

    private void registerController(JuIController controller) throws Exception {
        Stream<JuIWebSocket> websockets = controller.getWebSockets();
        websockets.forEach(ws -> this.registerWebSocket((JuIWebSocket)ws));
        Stream<JuIEndpoint> endpoints = controller.getEndpoints();
        endpoints.forEach(ed -> this.registerEndpoint((JuIEndpoint)ed));
        try {
            String swaggerJson = JuSwaggerParser.getSwaggerJson(controller);
            String name = controller.getClass().getSimpleName().toLowerCase();
            String path = "/swagger/" + name + "/";
            this.server.get(path, (req, res) -> JuResponseUtilities.setResponseAsJson(res, 200, swaggerJson));
            this.logger.info("Swagger for " + name + " - " + path);
        }
        catch (JsonProcessingException e) {
            throw new Exception(e);
        }
    }

    private void registerEndpoint(JuIEndpoint endpoint) {
        JuRoute route = endpoint.getRoute();
        JuVerb verb = endpoint.getVerb();
        String path = endpoint.getPath();
        this.logger.info("Register endpoint: " + verb + " [" + path + "]");
        switch (verb) {
            case GET: {
                this.server.get(path, (Route)route);
                return;
            }
            case PUT: {
                this.server.put(path, (Route)route);
                return;
            }
            case POST: {
                this.server.post(path, (Route)route);
                return;
            }
            case DELETE: {
                this.server.delete(path, (Route)route);
                return;
            }
        }
        throw new IllegalArgumentException("Verb not recognized!");
    }

    private void registerWebSocket(JuIWebSocket websocket) {
        Class<? extends JuWebSocketClass> clazz = websocket.getWebSocketClass();
        String path = "/" + websocket.getPath();
        this.logger.info("Register websocket: [" + path + "] :: " + websocket.getWebSocketClass());
        this.server.webSocket(path, clazz);
    }
}

