/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.standard;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.core.JuIPathParameter;
import tecgraf.javautils.sparkserver.core.JuIQueryParameter;
import tecgraf.javautils.sparkserver.core.JuIResponse;
import tecgraf.javautils.sparkserver.standard.JuPathParameter;
import tecgraf.javautils.sparkserver.standard.JuQueryParameter;
import tecgraf.javautils.sparkserver.standard.JuResponse;
import tecgraf.javautils.sparkserver.standard.JuRoute;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;

public class JuEndpoint
implements JuIEndpoint {
    public final JuVerb verb;
    public final String path;
    public final JuRoute route;
    private String name;
    private String description;
    private Set<JuIPathParameter> pathParameters = new HashSet<JuIPathParameter>();
    private Set<JuIQueryParameter> queryParameters = new HashSet<JuIQueryParameter>();
    private HashMap<Integer, JuIResponse> responses = new HashMap();

    public <T> JuEndpoint(JuVerb verb, String path, JuIFunction<T> function, Class<T> responseClass) {
        this(verb, path, new JuRoute<T>(function, responseClass));
    }

    public <T> JuEndpoint(JuVerb verb, String path, JuRoute<T> route) {
        if (verb == null) {
            throw new IllegalArgumentException("null verb not allowed!");
        }
        if (path == null) {
            throw new IllegalArgumentException("null path not allowed!");
        }
        if (route == null) {
            throw new IllegalArgumentException("null route not allowed!");
        }
        this.verb = verb;
        this.path = path;
        this.route = route;
    }

    @Override
    public JuVerb getVerb() {
        return this.verb;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public JuRoute getRoute() {
        return this.route;
    }

    @Override
    public String getName() {
        return this.name == null ? String.format("OP_%d", System.identityHashCode(this)) : this.name.trim();
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description.trim();
    }

    @Override
    public JuIEndpoint setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JuIEndpoint setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public List<String> findPathParameters() {
        String pth = this.getPath();
        List<String> allMatches = JuStringUtilities.getAllMatches(pth, ":(\\w+)");
        return allMatches.stream().map(p -> p.substring(1)).collect(Collectors.toList());
    }

    @Override
    public JuIPathParameter addPathParameter(String name) {
        boolean notFound = this.findPathParameters().stream().filter(pp -> pp.equals(name)).findAny().isEmpty();
        if (notFound) {
            throw new IllegalArgumentException("parameter not found" + name);
        }
        JuPathParameter parameter = new JuPathParameter(name);
        this.pathParameters.add(parameter);
        return parameter;
    }

    @Override
    public JuIQueryParameter addQueryParameter(String name) {
        JuQueryParameter parameter = new JuQueryParameter(name);
        this.queryParameters.add(parameter);
        return parameter;
    }

    @Override
    public JuIResponse addResponse(int code) {
        JuResponse parameter = new JuResponse(code);
        this.responses.put(code, parameter);
        return parameter;
    }

    @Override
    public Set<JuIPathParameter> getPathParameters() {
        return this.pathParameters;
    }

    @Override
    public Set<JuIQueryParameter> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public Collection<JuIResponse> getResponses() {
        if (this.responses.isEmpty()) {
            this.addResponse(200).setDescription("OK");
        }
        return this.responses.values();
    }

    public String toString() {
        return this.getVerb() + "::" + this.getPath();
    }
}

