package tecgraf.javautils.sparkserver.demo.echo;

import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.exceptions.JuBadRequestException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.standard.JuEndpoint;
import tecgraf.javautils.sparkserver.standard.JuRoute;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuRequestUtilities;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuSparkUtilities;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;

public class EchoController extends JuController {

  /**
   * Construtor
   */
  public EchoController() {
    addEndpoint(getDateEndpoint());
    addEndpoint(getDatesEndpoint());
    addEndpoint(getEchoEndpoint());

    setName("Root");
    setDescription("Controlador root com exemplos");
  }

  private JuIEndpoint getDatesEndpoint() {
    final List<EchoDate> dates = new ArrayList<>();
    final EchoDate date1 = new EchoDate(21, 4, 1500);
    final EchoDate date2 = new EchoDate(4, 6, 1971);
    final EchoDate date3 = new EchoDate(25, 12, 2020);
    dates.add(date1);
    dates.add(date2);
    dates.add(date3);

    final JuIFunction<List<EchoDate>> function = (req, res) -> {
      return JuResponseUtilities.setResponseAsJsonObject(res, 200, dates);
    };
    final Class<List<EchoDate>> listClass = JuSparkUtilities.getListClassOf(EchoDate.class);
    final JuRoute<List<EchoDate>> route = new JuRoute<>(function, listClass, EchoDate.class);

    final JuIEndpoint endpoint = new JuEndpoint(JuVerb.GET, "dates", route);
    endpoint.setName("dates").setDescription("Returns important dates");
    endpoint.addResponse(200).setDescription("Same object date").addExampleAsString("Clinio", dates);
    endpoint.addResponse(404).setDescription("Date not found!");
    return endpoint;
  }

  private JuIEndpoint getDateEndpoint() {
    final JuIFunction<EchoDate> function = (req, res) -> {
      final String _day = JuRequestUtilities.getRequestParameter(req, "day", true);
      final String _month = JuRequestUtilities.getRequestParameter(req, "month", true);
      final String _year = JuRequestUtilities.getRequestParameter(req, "year", true);
      if (_day == null || _month == null || _year == null) {
        throw new JuBadRequestException("not enough parameters!");
      }
      final Long day = JuStringUtilities.longOrNull(_day);
      final Long month = JuStringUtilities.longOrNull(_month);
      final Long year = JuStringUtilities.longOrNull(_year);
      if (day == null || month == null || year == null) {
        throw new JuBadRequestException("not valid parameters!");
      }
      final int d = day.intValue();
      final int m = month.intValue();
      final int y = year.intValue();
      final EchoDate date = new EchoDate(d, m, y);
      return JuResponseUtilities.setResponseAsJsonObject(res, 200, date);
    };
    final JuRoute<EchoDate> route = new JuRoute<>(function, EchoDate.class);

    final JuIEndpoint endpoint = new JuEndpoint(JuVerb.GET, "date/:day/:month/:year", route);
    endpoint.setName("date").setDescription("Returns a structure data base on path parameters");
    endpoint.addPathParameter("day").setDescription("day of year").setExampleAsString("31").setClassValue(Integer.class);
    endpoint.addPathParameter("month").setDescription("month of year").setExampleAsString("31").setClassValue(Integer.class);
    endpoint.addPathParameter("year").setDescription("year").setExampleAsString("1970").setClassValue(Integer.class);
    endpoint.addResponse(200).setDescription("Same object date").addExampleAsString("Clinio", new EchoDate(4, 6, 1971));
    endpoint.addResponse(404).setDescription("Date not found!");
    return endpoint;
  }

  private JuIEndpoint getEchoEndpoint() {
    final JuIFunction<EchoOutput> function = (req, res) -> {
      String input = JuRequestUtilities.getQueryParameter(req, "input", false);
      input = input == null ? "no-input" : input;
      final EchoOutput output = new EchoOutput(input);
      return JuResponseUtilities.setResponseAsJsonObject(res, 200, output);
    };
    final JuRoute<EchoOutput> route = new JuRoute<>(function, EchoOutput.class);

    final JuIEndpoint endpoint = new JuEndpoint(JuVerb.GET, "echo", route);
    endpoint.setName("echo").setDescription("Returns echo string based on query parameter");
    endpoint.addQueryParameter("input").setRequired(false).setClassValue(String.class).setDescription("Input")
            .setExampleAsString("yada yada");
    endpoint.addResponse(200).setDescription("Blah").addExampleAsString("blah", new EchoOutput("blah blah"));
    return endpoint;
  }


}
