package tecgraf.javautils.sparkserver.demo.ping;

import io.swagger.annotations.Api;

import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.exceptions.JuAuthorizationException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.standard.JuEndpoint;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;

public class PingController extends JuController {
  /**
   * Construtor
   */
  public PingController() {
    setPathPrefix("ping");
    setName("Ping");
    setDescription("Controlador ping com exemplos");

    addWebSocket("pingpong", PingWebSocket.class);
    addEndpoint(getOkEndpoint());
    addEndpoint(getNotOkEndpoint());
  }

  private JuIEndpoint getOkEndpoint() {
    final JuIFunction<String> function = (req, res) -> JuResponseUtilities.setResponseAsText(res, 200, "ok");
    final JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "ok", function, String.class);
    endpoint.setName("OK").setDescription("Returns OK");
    return endpoint;
  }

  private JuIEndpoint getNotOkEndpoint() {
    final JuIFunction<String> function = (req, res) -> {
      throw new JuAuthorizationException("NOT OK as expected!");
    };
    final JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "nok", function, String.class);
    endpoint.setName("NOT-OK").setDescription("Returns not OK");
    return endpoint;
  }
}
