package tecgraf.javautils.sparkserver.swagger;

public enum JuSwaggerTheme {

  FEELING_BLUE("theme-feeling-blue"),
  FLATTOP("theme-flattop"),
  MATERIAL("theme-material"),
  MONOKAI("theme-monokai"),
  MUTED("theme-muted"),
  NEWSPAPER("theme-newspaper"),
  OUTLINE("theme-outline");

  private String value;

  JuSwaggerTheme(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  public static JuSwaggerTheme fromValue(String value) {
    if (value != null) {
      for (JuSwaggerTheme theme : JuSwaggerTheme.values()) {
        if (theme.name().equals(value) || theme.getValue().equals(value)) {
          return theme;
        }
      }
    }
    return JuSwaggerTheme.OUTLINE;
  }
}