package tecgraf.javautils.sparkserver.library.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.sparkserver.library.standard.JuRoute;
import tecgraf.javautils.sparkserver.library.standard.JuVerb;

public interface JuIEndpoint {
  JuVerb getVerb();
  String getPath();
  JuRoute getRoute();

  String getName();
  String getDescription();
  JuIEndpoint setName(String name);
  JuIEndpoint setDescription(String description);

  List<String> findPathParameters();

  JuIPathParameter addPathParameter(String parameter);
  JuIQueryParameter addQueryParameter(String parameter);
  JuIResponse addResponse(int code);

  Set<JuIPathParameter> getPathParameters();
  Set<JuIQueryParameter> getQueryParameters();
  Collection<JuIResponse> getResponses();

}
