package tecgraf.javautils.sparkserver.library.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import tecgraf.javautils.sparkserver.library.standard.JuServer;

public class JuSwaggerParser {

  private final static Logger logger = LoggerFactory.getLogger(JuSwaggerParser.class);

  public static Swagger getSwagger(JuServer server) throws JsonProcessingException {
    final JuSwaggerReader reader = new JuSwaggerReader(server);
    final Swagger swagger = reader.read();
    return swagger;
  }

  public static String getSwaggerJsonString(Swagger swagger) throws JsonProcessingException {
    final String json = swaggerToJson(swagger);
    return json;
  }

  public static String swaggerToJson(Swagger swagger) throws JsonProcessingException {
    ObjectMapper objectMapper = new ObjectMapper();
    objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    String json = objectMapper.writeValueAsString(swagger);
    return json;
  }

}

