package tecgraf.javautils.sparkserver.library.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import tecgraf.javautils.sparkserver.library.core.JuIController;

public class JuStringUtilities {

  /**
   * Converte uma string em um long
   * @param txt texto
   * @return long ou null (se não for possível)
   * @throws IllegalArgumentException se o texto for nulo.
   */
  static public Long longOrNull(String txt) {
    if (txt == null) {
      throw new IllegalArgumentException("Invalid null to convertion!");
    }
    try {
      final Long l = Long.parseLong(txt.trim());
      return l;
    }
    catch (NumberFormatException nfe) {
      return null;
    }
  }

  /**
   * Converte uma string em um double
   * @param txt texto
   * @return long ou null (se não for possível)
   * @throws IllegalArgumentException se o texto for nulo.
   */
  static public Double doubleOrNull(String txt) {
    if (txt == null) {
      throw new IllegalArgumentException("Invalid null to conversion!");
    }
    try {
      final double d = Double.parseDouble(txt.trim());
      return d;
    }
    catch (NumberFormatException nfe) {
      return null;
    }
  }

  static public String getRealPath(JuIController controller, String path) {
    final String prefix = controller.getPathPrefix();
    final boolean noPath = path == null || path.trim().isBlank();
    final boolean noPrefix = prefix == null || prefix.trim().isBlank();
    if (noPath && noPrefix) return "/";
    if (noPath) return prefix;
    if (noPrefix) return path;
    return prefix + "/" + path;
  }

  public static List<String> getAllMatches(String text, String regex) {
    List<String> matches = new ArrayList<String>();
    Matcher m = Pattern.compile("(?=(" + regex + "))").matcher(text);
    while(m.find()) {
      matches.add(m.group(1));
    }
    return matches;
  }
}
