/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import tecgraf.javautils.gui.field.RegexDocument;

public abstract class AbstractRegexField
extends JTextField {
    public static final String ANY_STRING_REGEX = ".*";
    private Color backgroundError = Color.RED;
    private Color foregroundError = Color.BLACK;
    private boolean showValidation;
    private Border originalBorder;

    public AbstractRegexField() {
        this(false);
    }

    public AbstractRegexField(boolean showValidation) {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AbstractRegexField.this.showValidation();
            }
        });
        this.showValidation = showValidation;
        this.originalBorder = this.getBorder();
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.showValidation();
    }

    private void showValidation() {
        if (this.showValidation) {
            if (this.isValidValue() || this.getText().length() == 0) {
                this.setBorder(this.originalBorder);
                this.setForeground(Color.BLACK);
            } else {
                this.setBorder(BorderFactory.createLineBorder(this.backgroundError, 2));
                this.setForeground(this.foregroundError);
            }
        }
    }

    public abstract boolean isValidValue();

    protected RegexDocument getRegexDocument() {
        if (this.getDocument() instanceof RegexDocument) {
            return (RegexDocument)this.getDocument();
        }
        return null;
    }

    public void setBackgroundErrorColor(Color backgroundError) {
        this.backgroundError = backgroundError;
    }

    @Deprecated
    public void setBackgroundError(Color backgroundError) {
        this.backgroundError = backgroundError;
    }

    public void setBackgroundError(boolean showValidation) {
        this.showValidation = showValidation;
    }

    @Deprecated
    public void enableBackgroundError(boolean showValidation) {
        this.showValidation = showValidation;
    }

    public void setForegroundErrorColor(Color foregroundError) {
        this.foregroundError = foregroundError;
    }

    @Deprecated
    public void setForegroundError(Color foregroundError) {
        this.foregroundError = foregroundError;
    }
}

