/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.authorizations;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class AuthorizationInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel entityIDLabel;
    private JComboBox entityIDCombo;
    private JLabel interfacesLabel;
    private JList interfacesScrollList;
    private List<String> entitiesIDList;
    private List<String> interfacesList;
    private TablePanelComponent<AuthorizationWrapper> panel;

    public AuthorizationInputDialog(Window parentWindow, TablePanelComponent<AuthorizationWrapper> panel, BusAdmin admin, List<String> entitiesIDList, List<String> interfacesList) {
        super(parentWindow, LNG.get((String)(AuthorizationInputDialog.class.getSimpleName() + ".title")), admin);
        this.panel = panel;
        Collections.sort(entitiesIDList, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(interfacesList, String.CASE_INSENSITIVE_ORDER);
        this.entitiesIDList = entitiesIDList;
        this.interfacesList = interfacesList;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                String[] selectedInterfaces;
                String entityID = AuthorizationInputDialog.this.getEntityID();
                for (String selectedInterface : selectedInterfaces = AuthorizationInputDialog.this.getSelectedInterfaces()) {
                    AuthorizationInputDialog.this.admin.setAuthorization(entityID, selectedInterface);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    RegisteredEntityDesc desc = new RegisteredEntityDesc();
                    desc.id = AuthorizationInputDialog.this.getEntityID();
                    AuthorizationWrapper wrapper = new AuthorizationWrapper(desc, AuthorizationInputDialog.this.getSelectedInterfaces()[0]);
                    AuthorizationInputDialog.this.panel.refresh(null);
                    AuthorizationInputDialog.this.panel.selectElement(wrapper, true);
                }
            }
        };
        task.execute(this, Utils.getString(this.getClass(), "waiting.title"), Utils.getString(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.entityIDLabel = new JLabel(Utils.getString(this.getClass(), "entityID.label"));
        panel.add((Component)this.entityIDLabel, new GBC(0, 0).insets(5).none().west());
        this.entityIDCombo = new JComboBox<Object>(this.entitiesIDList.toArray());
        panel.add((Component)this.entityIDCombo, new GBC(0, 1).insets(5).horizontal().west());
        this.interfacesLabel = new JLabel(Utils.getString(this.getClass(), "interfaces.label"));
        panel.add((Component)this.interfacesLabel, new GBC(0, 2).insets(5).none().west());
        this.interfacesScrollList = new JList<Object>(this.interfacesList.toArray());
        panel.add((Component)new JScrollPane(this.interfacesScrollList), new GBC(0, 3).insets(5).both().west());
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.interfacesScrollList.isSelectionEmpty()) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyInterfaces"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    private String getEntityID() {
        return (String)this.entityIDCombo.getSelectedItem();
    }

    private String[] getSelectedInterfaces() {
        List selectedInterfaces = this.interfacesScrollList.getSelectedValuesList();
        return selectedInterfaces.toArray(new String[selectedInterfaces.size()]);
    }
}

