/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.utils;

import busexplorer.utils.Utils;

public class BusAddress {
    private String description;
    private String host;
    private int port;
    private String ior;
    private AddressType type;
    public static final BusAddress UNSPECIFIED_ADDRESS = new BusAddress();

    private BusAddress(String description, String host, int port) {
        this.description = description;
        this.host = host;
        this.port = port;
        this.type = AddressType.Address;
    }

    private BusAddress(String description, String ior) {
        this.description = description;
        this.ior = ior;
        this.type = AddressType.Reference;
    }

    private BusAddress() {
        this.description = Utils.getString(BusAddress.class, "unspecified");
        this.type = AddressType.Unspecified;
    }

    public String toString() {
        String text = null;
        switch (this.type) {
            case Address: {
                text = this.host + ":" + this.port;
                break;
            }
            case Reference: {
                text = "Hash(IOR)=" + this.ior.hashCode();
                break;
            }
            case Unspecified: {
                return this.description;
            }
        }
        if (this.description != null) {
            text = this.description + " (" + text + ")";
        }
        return text;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getIOR() {
        return this.ior;
    }

    public String getDescription() {
        return this.description;
    }

    public AddressType getType() {
        return this.type;
    }

    public static BusAddress toAddress(String description, String addressStr) {
        BusAddress address;
        try {
            if (addressStr.matches("^IOR:.+")) {
                address = new BusAddress(description, addressStr);
            } else {
                String[] addressContents = addressStr.split(":");
                address = new BusAddress(description, addressContents[0], Integer.parseInt(addressContents[1]));
            }
        }
        catch (Exception e) {
            String msg = String.format(Utils.getString(BusAddress.class, "warning.unreadableAddress"), addressStr);
            address = new BusAddress();
        }
        return address;
    }

    public static enum AddressType {
        Address,
        Reference,
        Unspecified;

    }
}

