/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.BusExplorerLogin;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.utils.BusAddress;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.ConfigurationProperties;
import busexplorer.utils.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.gui.GBC;

public class LoginDialog
extends JDialog {
    private JComboBox comboBus;
    private JComboBox comboDomain;
    private JTextField fieldAddress;
    private JTextField fieldUser;
    private JTextField fieldDomain;
    private JPasswordField fieldPassword;
    private JButton buttonLogin;
    private BusExplorerLogin login;

    public LoginDialog(Window owner) {
        super(owner, Language.get(LoginDialog.class, "title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.buildDialog();
    }

    private void buildDialog() {
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoginDialog.this.getOwner().dispose();
                System.exit(0);
            }
        });
        this.buildLoginPane();
        this.setLocationRelativeTo(this.getOwner());
    }

    public BusExplorerLogin getLogin() {
        return this.login;
    }

    private void buildLoginPane() {
        JPanel loginPanel = new JPanel(new BorderLayout());
        loginPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        JPanel configPanel = new JPanel(new MigLayout("fill, flowy"));
        TitledBorder configBorder = new TitledBorder(null, Language.get(this.getClass(), "config.label"));
        configPanel.setBorder(configBorder);
        Font FONT_LABEL = new Font("Dialog", 0, 12);
        EnableLoginListener enableLoginListener = new EnableLoginListener();
        SelectAllTextListener selectAllTextListener = new SelectAllTextListener();
        ConfigurationProperties configProps = new ConfigurationProperties();
        Vector<BusAddress> busVector = new Vector<BusAddress>();
        Vector busDomain = new Vector();
        int i = 1;
        while (true) {
            Object domain;
            String busPrefix = "bus" + i + ".";
            String description = configProps.getProperty(busPrefix + "description");
            String address = configProps.getProperty(busPrefix + "address");
            if (description == null || address == null) break;
            busDomain.add(new Vector());
            int j = 1;
            while ((domain = configProps.getProperty(busPrefix + "domain" + j)) != null) {
                ((Vector)busDomain.get(i - 1)).add(domain);
                ++j;
            }
            busVector.add(BusAddress.toAddress(description, address));
            ++i;
        }
        this.fieldAddress = new JTextField(30);
        if (!busVector.isEmpty()) {
            busVector.add(BusAddress.UNSPECIFIED_ADDRESS);
            busDomain.add(new Vector());
            JLabel labelBus = new JLabel(Language.get(this.getClass(), "bus.label"));
            labelBus.setFont(FONT_LABEL);
            configPanel.add((Component)labelBus, "grow");
            this.comboBus = new JComboBox(busVector);
            this.comboBus.addItemListener(e -> {
                BusAddress selectedBus = (BusAddress)this.comboBus.getSelectedItem();
                this.updateAddress(selectedBus);
                if (selectedBus.getType().equals((Object)BusAddress.AddressType.Unspecified)) {
                    this.fieldAddress.setEnabled(true);
                    this.fieldAddress.requestFocus();
                } else {
                    this.fieldAddress.setEnabled(false);
                    this.fieldUser.requestFocus();
                }
            });
            configPanel.add((Component)this.comboBus, "grow");
        }
        JLabel labelHost = new JLabel(Language.get(this.getClass(), "host.label"));
        labelHost.setFont(FONT_LABEL);
        configPanel.add((Component)labelHost, "grow");
        this.fieldAddress.setToolTipText(Language.get(this.getClass(), "host.help"));
        this.fieldAddress.addFocusListener(selectAllTextListener);
        this.fieldAddress.getDocument().addDocumentListener(enableLoginListener);
        this.fieldAddress.setFocusable(true);
        if (!busVector.isEmpty()) {
            this.fieldAddress.setEnabled(false);
        }
        configPanel.add((Component)this.fieldAddress, "grow");
        JLabel labelUser = new JLabel(Language.get(this.getClass(), "user.label"));
        labelUser.setFont(FONT_LABEL);
        configPanel.add((Component)labelUser, "grow");
        this.fieldUser = new JTextField();
        this.fieldUser.setToolTipText(Language.get(this.getClass(), "user.help"));
        this.fieldUser.addFocusListener(selectAllTextListener);
        this.fieldUser.getDocument().addDocumentListener(enableLoginListener);
        this.fieldUser.setFocusable(true);
        configPanel.add((Component)this.fieldUser, "grow");
        JLabel labelPassword = new JLabel(Language.get(this.getClass(), "password.label"));
        labelPassword.setFont(FONT_LABEL);
        configPanel.add((Component)labelPassword, "grow");
        this.fieldPassword = new JPasswordField();
        this.fieldPassword.setToolTipText(Language.get(this.getClass(), "password.help"));
        this.fieldPassword.addFocusListener(selectAllTextListener);
        this.fieldPassword.setFocusable(true);
        configPanel.add((Component)this.fieldPassword, "grow");
        JPanel domainPanel = new JPanel(new MigLayout("ins 0, fill", "[][]", "[]"));
        JLabel labelDomain = new JLabel(Language.get(this.getClass(), "domain.label"));
        labelDomain.setFont(FONT_LABEL);
        domainPanel.add((Component)labelDomain, "grow, wrap");
        this.fieldDomain = new JTextField();
        this.fieldDomain.setToolTipText(Language.get(this.getClass(), "domain.help"));
        this.fieldDomain.addFocusListener(selectAllTextListener);
        this.fieldDomain.setFocusable(true);
        domainPanel.add((Component)this.fieldDomain, "grow, push");
        this.comboDomain = new JComboBox();
        this.comboDomain.setEnabled(false);
        domainPanel.add((Component)this.comboDomain, "grow");
        configPanel.add((Component)domainPanel, "grow");
        loginPanel.add((Component)configPanel, "Center");
        this.buttonLogin = new JButton(Language.get(this.getClass(), "confirm.button"));
        this.buttonLogin.setMnemonic(Language.get(this.getClass(), "confirm.button.mnemonic").charAt(0));
        this.buttonLogin.setToolTipText(Language.get(this.getClass(), "confirm.help"));
        this.buttonLogin.addActionListener(new LoginAction());
        this.buttonLogin.setIcon(ApplicationIcons.ICON_LOGIN_16);
        this.buttonLogin.setEnabled(false);
        if (!busDomain.isEmpty()) {
            this.comboBus.addItemListener(listener -> {
                this.comboDomain.removeAllItems();
                BusAddress selectedBus = (BusAddress)this.comboBus.getSelectedItem();
                for (String d : (Vector)busDomain.get(busVector.indexOf(selectedBus))) {
                    this.comboDomain.addItem(d);
                }
                if (this.comboDomain.getItemCount() == 0) {
                    this.comboDomain.setEnabled(false);
                    this.fieldDomain.setEnabled(true);
                } else {
                    this.comboDomain.setEnabled(true);
                }
            });
            this.comboDomain.addItemListener(listener -> {
                String selected = (String)this.comboDomain.getSelectedItem();
                this.fieldDomain.setText(selected);
                this.fieldDomain.setEnabled(false);
                this.buttonLogin.requestFocus();
            });
            for (String d : (Vector)busDomain.get(busVector.indexOf(busVector.get(0)))) {
                this.comboDomain.addItem(d);
            }
            if (this.comboDomain.getItemCount() == 0) {
                this.comboDomain.setEnabled(false);
                this.fieldDomain.setEnabled(true);
            } else {
                this.comboDomain.setEnabled(true);
            }
        }
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.setBorder(new EmptyBorder(9, 3, 3, 3));
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.buttonLogin);
        loginPanel.add((Component)buttonsBox, "South");
        JPanel leftBox = new JPanel(new GridBagLayout());
        leftBox.add(new JLabel(new ImageIcon(ApplicationIcons.BUSEXPLORER_LIST[ApplicationIcons.BUSEXPLORER_LIST.length - 1])));
        String[] version = Application.version();
        JLabel apiVersion = new JLabel(version[0]);
        apiVersion.setFont(new Font(apiVersion.getFont().getFontName(), 0, (int)((double)apiVersion.getFont().getSize() * 1.5)));
        leftBox.add((Component)apiVersion, new GBC(0, 1).insets(10));
        JLabel appVersion = new JLabel(version[1]);
        appVersion.setFont(new Font(appVersion.getFont().getFontName(), 0, (int)((double)appVersion.getFont().getSize() * 1.2)));
        leftBox.add((Component)appVersion, new GBC(0, 2).insets(10));
        loginPanel.add((Component)leftBox, "West");
        this.setContentPane(loginPanel);
        this.getRootPane().setDefaultButton(this.buttonLogin);
        this.pack();
        this.fillLoginForm();
    }

    private void fillLoginForm() {
        String propertyHost = System.getProperty("host");
        String propertyPort = System.getProperty("port");
        try {
            Integer.parseInt(propertyPort);
        }
        catch (NumberFormatException e) {
            propertyPort = null;
        }
        if (propertyHost == null && propertyPort == null) {
            if (this.comboBus != null) {
                this.updateAddress((BusAddress)this.comboBus.getSelectedItem());
                this.fieldUser.requestFocus();
            } else {
                this.fieldAddress.requestFocus();
            }
        } else {
            if (this.comboBus != null) {
                this.comboBus.setSelectedItem(BusAddress.UNSPECIFIED_ADDRESS);
            }
            this.fieldAddress.setText(propertyHost);
            if (propertyHost == null) {
                this.fieldAddress.requestFocus();
            } else {
                this.fieldUser.requestFocus();
            }
        }
    }

    private void updateAddress(BusAddress selectedBus) {
        switch (selectedBus.getType()) {
            case Address: {
                this.fieldAddress.setText(String.format("%s:%d", selectedBus.getHost(), selectedBus.getPort()));
                break;
            }
            case Reference: {
                this.fieldAddress.setText(selectedBus.getIOR());
                break;
            }
            case Unspecified: {
                this.fieldAddress.setText("");
            }
        }
    }

    private class EnableLoginListener
    implements DocumentListener {
        private EnableLoginListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validate();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validate();
        }

        private void validate() {
            String text = LoginDialog.this.fieldAddress.getText().trim();
            BusAddress address = BusAddress.toAddress(null, text);
            if (text.length() > 0 && !address.getType().equals((Object)BusAddress.AddressType.Unspecified) && LoginDialog.this.fieldUser.getText().trim().length() > 0) {
                LoginDialog.this.buttonLogin.setEnabled(true);
            } else {
                LoginDialog.this.buttonLogin.setEnabled(false);
            }
        }
    }

    private class LoginAction
    implements ActionListener {
        private LoginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.LoginByPassword){
                BusExplorerLogin theLogin;

                @Override
                protected void doPerformTask() throws Exception {
                    BusAddress address;
                    if (LoginDialog.this.comboBus == null) {
                        address = BusAddress.toAddress(null, LoginDialog.this.fieldAddress.getText().trim());
                    } else {
                        address = (BusAddress)LoginDialog.this.comboBus.getSelectedItem();
                        if (address.getType().equals((Object)BusAddress.AddressType.Unspecified)) {
                            address = BusAddress.toAddress(null, LoginDialog.this.fieldAddress.getText().trim());
                        }
                    }
                    String entity = LoginDialog.this.fieldUser.getText().trim();
                    String domain = LoginDialog.this.fieldDomain.getText().trim();
                    String password = new String(LoginDialog.this.fieldPassword.getPassword());
                    this.theLogin = new BusExplorerLogin(address, entity, domain);
                    this.theLogin.doLogin(password);
                }

                @Override
                protected void afterTaskUI() {
                    if (this.getStatus()) {
                        LoginDialog.this.dispose();
                        LoginDialog.this.login = this.theLogin;
                    } else {
                        if (this.theLogin != null) {
                            this.theLogin.logout();
                        }
                        LoginDialog.this.fieldUser.requestFocus();
                    }
                }
            };
            task.execute((Window)LoginDialog.this, Language.get(LoginDialog.class, "waiting.title"), Language.get(LoginDialog.class, "waiting.msg"), 2, 0);
        }
    }

    private class SelectAllTextListener
    extends FocusAdapter {
        private SelectAllTextListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            ((JTextField)event.getComponent()).selectAll();
        }
    }
}

