/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.contracts;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.contracts.ContractInputDialog;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.gui.StandardDialogs;

public class ContractAddAction
extends OpenBusAction<ContractWrapper> {
    public ContractAddAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ADD;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<String>> task = new BusExplorerTask<List<String>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setResult(Application.login().admin.getInterfaces());
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    List result = (List)this.getResult();
                    if (result.size() == 0) {
                        StandardDialogs.showErrorDialog(this.parentWindow, ContractAddAction.this.getString("error.title"), ContractAddAction.this.getString("error.nointerfaces"));
                    } else {
                        new ContractInputDialog(ContractAddAction.this.parentWindow, ContractAddAction.this.getTablePanelComponent(), (List)this.getResult()).showDialog();
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

