/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import tecgraf.openbus.services.governance.v1_0.Contract;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class ProviderWrapper {
    private final Provider remote;
    private String name;
    private String code;
    private String supportoffice;
    private String manageroffice;
    private List<String> support;
    private List<String> manager;
    private String busquery;
    private List<String> contracts;

    public ProviderWrapper(Provider remote) {
        this.remote = remote;
        this.name = remote.name();
        this.code = remote.code();
        this.supportoffice = remote.supportoffice();
        this.manageroffice = remote.manageroffice();
        this.support = new ArrayList<String>(Arrays.asList(remote.support()));
        this.manager = new ArrayList<String>(Arrays.asList(remote.manager()));
        this.busquery = remote.busquery();
        this.contracts = new ArrayList<String>();
        for (Contract contract : remote.contracts()) {
            this.contracts.add(contract.name());
        }
    }

    public String name() {
        return this.name;
    }

    public void name(String updated) {
        if (!this.remote.name().equals(updated)) {
            this.remote.name(updated);
            this.name = updated;
        }
    }

    public String code() {
        return this.code;
    }

    public void code(String updated) {
        if (!this.remote.code().equals(updated)) {
            this.remote.code(updated);
            this.code = updated;
        }
    }

    public String manageroffice() {
        return this.manageroffice;
    }

    public void manageroffice(String updated) {
        if (!this.remote.manageroffice().equals(updated)) {
            this.remote.manageroffice(updated);
            this.manageroffice = updated;
        }
    }

    public String supportoffice() {
        return this.supportoffice;
    }

    public void supportoffice(String updated) {
        if (!this.remote.supportoffice().equals(updated)) {
            this.remote.supportoffice(updated);
            this.supportoffice = updated;
        }
    }

    public List<String> support() {
        return Collections.unmodifiableList(this.support);
    }

    public void support(List<String> updated) {
        this.remote.support(updated.toArray(new String[0]));
        this.support = updated;
    }

    public List<String> manager() {
        return Collections.unmodifiableList(this.manager);
    }

    public void manager(List<String> updated) {
        this.remote.manager(updated.toArray(new String[0]));
        this.manager = updated;
    }

    public String busquery() {
        return this.busquery;
    }

    public void busquery(String updated) {
        if (!this.remote.busquery().equals(updated)) {
            this.remote.busquery(updated);
            this.busquery = updated;
        }
    }

    public List<String> contracts() {
        return Collections.unmodifiableList(this.contracts);
    }

    public void contracts(List<String> updated) {
        for (String iface : updated) {
            if (this.contracts.contains(iface)) continue;
            this.remote.addContract(iface);
            this.contracts.add(iface);
        }
        ListIterator<String> iterator = this.contracts.listIterator();
        while (iterator.hasNext()) {
            String iface;
            iface = iterator.next();
            if (updated.contains(iface)) continue;
            this.remote.removeContract(iface);
            iterator.remove();
        }
    }

    public Provider remote() {
        return this.remote;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProviderWrapper)) {
            return false;
        }
        ProviderWrapper other = (ProviderWrapper)o;
        return this.name.equals(other.name);
    }

    public static List<ProviderWrapper> convertToInfo(List<Provider> entities) {
        ArrayList<ProviderWrapper> list = new ArrayList<ProviderWrapper>();
        for (Provider provider : entities) {
            list.add(new ProviderWrapper(provider));
        }
        return list;
    }
}

