/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.remoteobject;

import org.jacorb.ir.gui.remoteobject.ObjectRepresentant;
import org.jacorb.ir.gui.remoteobject.RemoteObject;
import org.jacorb.ir.gui.remoteobject.Struct;
import org.jacorb.ir.gui.typesystem.ModelBuilder;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRInterface;
import org.jacorb.ir.gui.typesystem.remote.IRStruct;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBSingleton;
import org.omg.CORBA.Object;
import org.omg.CORBA.PrimitiveDef;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.TCKind;

public class ObjectRepresentantFactory {
    private static ORB orb = ORBSingleton.init();

    public static ObjectRepresentant create(java.lang.Object counterPart, TypeSystemNode type, TypeAssociator referencedBy) {
        String name = null;
        if (referencedBy != null) {
            name = ((TypeSystemNode)((java.lang.Object)referencedBy)).getName();
        }
        if (type instanceof IRInterface) {
            return new RemoteObject((Object)counterPart, type, name);
        }
        if (type instanceof IRStruct) {
            return new Struct(counterPart, (IRStruct)type, name);
        }
        return new ObjectRepresentant(counterPart, type, name);
    }

    public static ObjectRepresentant create(Object counterPart) {
        IRInterface typeSystemNode = (IRInterface)RemoteTypeSystem.createTypeSystemNode(InterfaceDefHelper.narrow(counterPart._get_interface_def()));
        return ObjectRepresentantFactory.create(counterPart, typeSystemNode, null);
    }

    public static ObjectRepresentant createFromIOR(String ior) {
        Object obj = orb.string_to_object(ior);
        return ObjectRepresentantFactory.create(obj);
    }

    protected static void insertFromString(Any result, String value, TCKind kind) {
        switch (kind.value()) {
            case 0: 
            case 1: 
            case 2: {
                result.insert_short(Short.parseShort(value));
                break;
            }
            case 3: {
                result.insert_long(Integer.parseInt(value));
                break;
            }
            case 4: {
                result.insert_ushort(Short.parseShort(value));
                break;
            }
            case 5: {
                result.insert_ulong(Integer.parseInt(value));
                break;
            }
            case 6: {
                result.insert_float(new Float(value).floatValue());
                break;
            }
            case 7: {
                result.insert_double(new Double(value));
                break;
            }
            case 8: {
                result.insert_boolean(new Boolean(value));
                break;
            }
            case 9: {
                result.insert_char(value.charAt(0));
                break;
            }
            case 10: {
                result.insert_octet(new Byte(value));
                break;
            }
            case 14: {
                result.insert_Object(orb.string_to_object(value));
                break;
            }
            case 17: {
                result.insert_long(Integer.parseInt(value));
                break;
            }
            case 18: {
                result.insert_string(value);
                break;
            }
            case 23: {
                result.insert_longlong(Long.parseLong(value));
                break;
            }
            case 24: {
                result.insert_ulonglong(Long.parseLong(value));
                break;
            }
            case 26: {
                result.insert_wchar(value.charAt(0));
                break;
            }
            case 27: {
                result.insert_wstring(value);
                break;
            }
        }
    }

    public static void main(String[] args) {
        try {
            Repository rep = RepositoryHelper.narrow(orb.resolve_initial_references("InterfaceRepository"));
            PrimitiveDef prim = rep.get_primitive(PrimitiveKind.pk_short);
            InterfaceDef intf = InterfaceDefHelper.narrow(prim._get_interface_def());
            ObjectRepresentant objr = ObjectRepresentantFactory.create(prim, RemoteTypeSystem.createTypeSystemNode(intf), null);
            ModelBuilder.getSingleton().buildTreeModelAsync(objr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static java.lang.Object objectFromAny(Any any) {
        switch (any.type().kind().value()) {
            case 0: {
                return null;
            }
            case 1: {
                System.out.println("DII returned an Any of kind void?");
                return null;
            }
            case 2: {
                return new Short(any.extract_short());
            }
            case 3: {
                return new Integer(any.extract_long());
            }
            case 4: {
                return new Short(any.extract_ushort());
            }
            case 5: {
                return new Integer(any.extract_ulong());
            }
            case 6: {
                return new Float(any.extract_float());
            }
            case 7: {
                return new Double(any.extract_double());
            }
            case 8: {
                return new Boolean(any.extract_boolean());
            }
            case 9: {
                return new Character(any.extract_char());
            }
            case 10: {
                return new Byte(any.extract_octet());
            }
            case 11: {
                return any.extract_any();
            }
            case 12: {
                return any.extract_TypeCode();
            }
            case 13: {
                return any.extract_Principal();
            }
            case 14: {
                return any.extract_Object();
            }
            case 18: {
                return any.extract_string();
            }
            case 23: {
                return new Long(any.extract_longlong());
            }
            case 24: {
                return new Long(any.extract_ulonglong());
            }
            case 26: {
                return new Character(any.extract_wchar());
            }
            case 27: {
                return new String(any.extract_wstring());
            }
        }
        return null;
    }
}

