/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.table.SortableTable;
import tecgraf.javautils.gui.table.TotalizerModelWrapper;

public class TotalizerModelWrapperSample {
    public static void main(String[] args) {
        final TotalizerModelWrapper modelWrapper = new TotalizerModelWrapper(new TestModel(), new int[]{2, 3}, "Total");
        SortableTable table = new SortableTable((TableModel)modelWrapper, true);
        table.setSelectionMode(0);
        table.adjustColumnWidth();
        JScrollPane tablePane = new JScrollPane(table);
        JButton buttonNewRow = new JButton("Nova linha");
        buttonNewRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((TestModel)modelWrapper.getModel()).addRow("F", "Pablo", 23.0f);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(buttonNewRow);
        JFrame frame = new JFrame("Totalizer 1.6");
        frame.setDefaultCloseOperation(3);
        frame.add((Component)tablePane, "Center");
        frame.add((Component)buttonPanel, "West");
        int width = 650;
        int height = 400;
        frame.setSize(width, height);
        int FRAME_INTERNAL_MARGIN = 13;
        table.setPreferredScrollableViewportSize(new Dimension(width - 13, table.getPreferredScrollableViewportSize().height));
        frame.setVisible(true);
    }

    private static class TestModel
    extends AbstractTableModel {
        List<List<?>> values = new ArrayList();
        String[] headers = new String[]{"Col A", "Col B", "Col C", "Col D"};

        public TestModel() {
            this.values.add(Arrays.asList("A", "Jo\u00e3o", new Float(2.15), 0));
            this.values.add(Arrays.asList("D", "J\u00f3", new Float(1.335), 1));
            this.values.add(Arrays.asList("g", "Rom\u00eao", Float.valueOf(2.23f), 2));
            this.values.add(Arrays.asList("v", "Luis", Float.valueOf(11.0f), 3));
            this.values.add(Arrays.asList("E", "", null, 4));
            this.values.add(Arrays.asList("S", null, new Float(665.5524), 5));
            this.values.add(Arrays.asList("Z", null, null, 6));
        }

        public void addRow(String letter, String name, float number) {
            int newIndex = this.values.size();
            this.values.add(Arrays.asList(letter, name, Float.valueOf(number), newIndex));
            this.fireTableRowsInserted(newIndex, newIndex);
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public int getColumnCount() {
            return this.values.get(0).size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.values.get(rowIndex).get(columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.headers[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.values.get(0).get(columnIndex).getClass();
        }
    }
}

