/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.RequestInfo;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_1.credential.SignedData;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.security.Cryptography;

abstract class InterceptorImpl
extends LocalObject
implements Interceptor {
    protected static final byte BUS_MAJOR_VERSION = 2;
    protected static final byte BUS_MINOR_VERSION = 1;
    protected static final int HASH_VALUE_SIZE = 32;
    protected static final byte[] NULL_HASH_VALUE = new byte[32];
    protected static final int ENCRYPTED_BLOCK_SIZE = 256;
    protected static final byte[] NULL_ENCRYPTED_BLOCK = new byte[256];
    protected static final SignedData NULL_SIGNED_CALL_CHAIN = new SignedData(NULL_ENCRYPTED_BLOCK, new byte[0]);
    protected static final byte LEGACY_MAJOR_VERSION = 2;
    protected static final byte LEGACY_MINOR_VERSION = 0;
    protected static final SignedCallChain NULL_SIGNED_LEGACY_CALL_CHAIN = new SignedCallChain(NULL_ENCRYPTED_BLOCK, new byte[0]);
    private final String name;
    private final ORBMediator mediator;

    protected InterceptorImpl(String name, ORBMediator mediator) {
        this.name = name;
        this.mediator = mediator;
    }

    @Override
    public String name() {
        return this.name;
    }

    protected final ORBMediator mediator() {
        return this.mediator;
    }

    protected final ORB orb() {
        return this.mediator.getORB();
    }

    protected final Codec codec() {
        return this.mediator.getCodec();
    }

    protected final OpenBusContextImpl context() {
        return this.mediator.getContext();
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] generateCredentialDataHash(RequestInfo ri, byte[] secret, int ticket, boolean legacy) {
        try {
            MessageDigest hashAlgorithm;
            Cryptography crypto = Cryptography.getInstance();
            MessageDigest messageDigest = hashAlgorithm = crypto.getHashAlgorithm();
            synchronized (messageDigest) {
                if (!legacy) {
                    hashAlgorithm.update((byte)2);
                    hashAlgorithm.update((byte)1);
                    hashAlgorithm.update(secret);
                } else {
                    hashAlgorithm.update((byte)2);
                    hashAlgorithm.update((byte)0);
                    hashAlgorithm.update(secret);
                }
                ByteBuffer ticketBuffer = ByteBuffer.allocate(4);
                ticketBuffer.order(ByteOrder.LITTLE_ENDIAN);
                ticketBuffer.putInt(ticket);
                ticketBuffer.flip();
                hashAlgorithm.update(ticketBuffer);
                byte[] operationBytes = ri.operation().getBytes(Cryptography.CHARSET);
                hashAlgorithm.update(operationBytes);
                return hashAlgorithm.digest();
            }
        }
        catch (CryptographyException e) {
            String message = "Falha inesperada ao calcular o hash da credencial";
            throw new INTERNAL(message);
        }
    }
}

