/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.authorizations;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class AuthorizationInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel entityIDLabel;
    private JComboBox entityIDCombo;
    private JLabel interfacesLabel;
    private JList interfacesScrollList;
    private List<String> entitiesIDList;
    private List<String> interfacesList;
    private TablePanelComponent<AuthorizationWrapper> panel;

    public AuthorizationInputDialog(Window parentWindow, TablePanelComponent<AuthorizationWrapper> panel, List<String> entitiesIDList, List<String> interfacesList) {
        super(parentWindow);
        this.panel = panel;
        Collections.sort(entitiesIDList, String.CASE_INSENSITIVE_ORDER);
        Collections.sort(interfacesList, String.CASE_INSENSITIVE_ORDER);
        this.entitiesIDList = entitiesIDList;
        this.interfacesList = interfacesList;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                String[] selectedInterfaces;
                String entityID = AuthorizationInputDialog.this.getEntityID();
                for (String selectedInterface : selectedInterfaces = AuthorizationInputDialog.this.getSelectedInterfaces()) {
                    Application.login().admin.setAuthorization(entityID, selectedInterface);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    RegisteredEntityDesc desc = new RegisteredEntityDesc();
                    desc.id = AuthorizationInputDialog.this.getEntityID();
                    AuthorizationWrapper wrapper = new AuthorizationWrapper(desc, AuthorizationInputDialog.this.getSelectedInterfaces()[0]);
                    AuthorizationInputDialog.this.panel.refresh(null);
                    AuthorizationInputDialog.this.panel.selectElement(wrapper, true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(550, 350));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.entityIDLabel = new JLabel(Language.get(this.getClass(), "entityID.label"));
        panel.add((Component)this.entityIDLabel, "grow");
        this.entityIDCombo = new JComboBox<Object>(this.entitiesIDList.toArray());
        panel.add((Component)this.entityIDCombo, "grow");
        this.interfacesLabel = new JLabel(Language.get(this.getClass(), "interfaces.label"));
        panel.add((Component)this.interfacesLabel, "grow");
        this.interfacesScrollList = new JList<Object>(this.interfacesList.toArray());
        this.interfacesScrollList.addListSelectionListener(listener -> {
            if (listener.getFirstIndex() != -1 && listener.getLastIndex() != -1) {
                this.clearErrorMessage();
            }
        });
        panel.add((Component)new JScrollPane(this.interfacesScrollList), "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.interfacesScrollList.isSelectionEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.emptyInterfaces"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    private String getEntityID() {
        return (String)this.entityIDCombo.getSelectedItem();
    }

    private String[] getSelectedInterfaces() {
        List selectedInterfaces = this.interfacesScrollList.getSelectedValuesList();
        return selectedInterfaces.toArray(new String[selectedInterfaces.size()]);
    }
}

