/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.providers;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.BusQueryHelpAction;
import busexplorer.panel.BusQueryValidateAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import busexplorer.utils.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.omg.CORBA.BAD_PARAM;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class ProviderInputDialog
extends BusExplorerAbstractInputDialog {
    private JTextField nameTextField;
    private JTextField codeTextField;
    private JTextField supportOfficeTextField;
    private JTextField managerOfficeTextField;
    private JTextField supportTextField;
    private JTextField managerTextField;
    private JTextArea queryTextField;
    private BusQueryValidateAction<JTextArea, String> queryValidation;
    private JList<String> contractList;
    private TreeMap<String, ContractWrapper> contracts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TablePanelComponent<ProviderWrapper> panel;
    private ProviderWrapper editingProvider = null;

    public ProviderInputDialog(Window parentWindow, TablePanelComponent<ProviderWrapper> panel, List<ContractWrapper> contracts) {
        super(parentWindow);
        this.panel = panel;
        for (ContractWrapper contract : contracts) {
            this.contracts.put(contract.name(), contract);
        }
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                if (ProviderInputDialog.this.editingProvider == null) {
                    Provider provider;
                    try {
                        provider = Application.login().extension.getProviderRegistry().add(ProviderInputDialog.this.nameTextField.getText().trim());
                    }
                    catch (BAD_PARAM e) {
                        throw new IllegalArgumentException(Language.get(ProviderInputDialog.class, "error.alreadyinuse.name"), e);
                    }
                    provider.code(ProviderInputDialog.this.codeTextField.getText().trim());
                    provider.supportoffice(ProviderInputDialog.this.supportOfficeTextField.getText().trim());
                    provider.manageroffice(ProviderInputDialog.this.managerOfficeTextField.getText().trim());
                    provider.support(StringUtilities.splitOmmitEmpty(ProviderInputDialog.this.supportTextField.getText(), ",").toArray(new String[0]));
                    provider.manager(StringUtilities.splitOmmitEmpty(ProviderInputDialog.this.managerTextField.getText(), ",").toArray(new String[0]));
                    provider.busquery(ProviderInputDialog.this.queryTextField.getText().trim());
                    ProviderInputDialog.this.contractList.getSelectedValuesList().forEach(arg_0 -> ((Provider)provider).addContract(arg_0));
                    ProviderInputDialog.this.editingProvider = new ProviderWrapper(provider);
                } else {
                    try {
                        ProviderInputDialog.this.editingProvider.name(ProviderInputDialog.this.nameTextField.getText().trim());
                    }
                    catch (BAD_PARAM e) {
                        throw new IllegalArgumentException(Language.get(ProviderInputDialog.class, "error.alreadyinuse.name"), e);
                    }
                    ProviderInputDialog.this.editingProvider.code(ProviderInputDialog.this.codeTextField.getText().trim());
                    ProviderInputDialog.this.editingProvider.supportoffice(ProviderInputDialog.this.supportOfficeTextField.getText().trim());
                    ProviderInputDialog.this.editingProvider.manageroffice(ProviderInputDialog.this.managerOfficeTextField.getText().trim());
                    ProviderInputDialog.this.editingProvider.support(StringUtilities.splitOmmitEmpty(ProviderInputDialog.this.supportTextField.getText(), ","));
                    ProviderInputDialog.this.editingProvider.manager(StringUtilities.splitOmmitEmpty(ProviderInputDialog.this.managerTextField.getText(), ","));
                    ProviderInputDialog.this.editingProvider.busquery(ProviderInputDialog.this.queryTextField.getText().trim());
                    ProviderInputDialog.this.editingProvider.contracts(ProviderInputDialog.this.contractList.getSelectedValuesList());
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    ProviderInputDialog.this.panel.refresh(null);
                    ProviderInputDialog.this.panel.selectElement(ProviderInputDialog.this.editingProvider, true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(550, 580));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "[]10[]"));
        JLabel nameLabel = new JLabel(Language.get(this.getClass(), "name.label"));
        panel.add((Component)nameLabel, "grow");
        this.nameTextField = new JTextField();
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (ProviderInputDialog.this.nameTextField.getText().trim().isEmpty()) {
                    ProviderInputDialog.this.setErrorMessage(Language.get(ProviderInputDialog.class, "error.validation.name"));
                } else {
                    ProviderInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.nameTextField, "grow");
        JLabel codeLabel = new JLabel(Language.get(this.getClass(), "code.label"));
        panel.add((Component)codeLabel, "grow");
        this.codeTextField = new JTextField();
        panel.add((Component)this.codeTextField, "grow");
        JLabel supportOfficeLabel = new JLabel(Language.get(this.getClass(), "supportoffice.label"));
        panel.add((Component)supportOfficeLabel, "grow");
        this.supportOfficeTextField = new JTextField();
        panel.add((Component)this.supportOfficeTextField, "grow");
        JLabel supportLabel = new JLabel(Language.get(this.getClass(), "support.label"));
        panel.add((Component)supportLabel, "grow");
        this.supportTextField = new JTextField();
        panel.add((Component)this.supportTextField, "grow");
        JLabel managerOfficeLabel = new JLabel(Language.get(this.getClass(), "manageroffice.label"));
        panel.add((Component)managerOfficeLabel, "grow");
        this.managerOfficeTextField = new JTextField();
        panel.add((Component)this.managerOfficeTextField, "grow");
        JLabel managerLabel = new JLabel(Language.get(this.getClass(), "manager.label"));
        panel.add((Component)managerLabel, "grow");
        this.managerTextField = new JTextField();
        panel.add((Component)this.managerTextField, "grow");
        JLabel queryLabel = new JLabel(Language.get(this.getClass(), "busquery.label"));
        panel.add((Component)queryLabel, "grow");
        this.queryTextField = new JTextArea(5, 20);
        this.queryTextField.setLineWrap(true);
        this.queryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProviderInputDialog.this.hasValidFields();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.queryValidation = new BusQueryValidateAction<JTextArea, String>(this, this.queryTextField, jTextArea -> jTextArea.getText().trim());
        JPanel busQueryPanel = new JPanel((LayoutManager)new MigLayout("wrap 2, ins 0", "[grow][]", "[grow][grow]"));
        busQueryPanel.add((Component)new JScrollPane(this.queryTextField), "grow, push, span 1 2");
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("flowy, ins 0"));
        buttonsPanel.add((Component)new JButton(this.queryValidation), "grow");
        buttonsPanel.add((Component)new JButton(new BusQueryHelpAction(this)), "grow");
        busQueryPanel.add((Component)buttonsPanel, "grow, gapbottom push");
        panel.add((Component)busQueryPanel, "grow, push, wrap");
        JLabel contractLabel = new JLabel(Language.get(this.getClass(), "contracts.label"));
        panel.add((Component)contractLabel, "grow");
        this.contractList = new JList<String>(this.contracts.keySet().toArray(new String[this.contracts.size()]));
        this.contractList.setSelectionMode(2);
        this.contractList.setVisibleRowCount(4);
        this.contractList.addListSelectionListener(listener -> {
            if (listener.getFirstIndex() != -1 && listener.getLastIndex() != -1) {
                this.clearErrorMessage();
            }
        });
        panel.add((Component)new JScrollPane(this.contractList), "grow, pushx, spany " + (panel.getComponentCount() - 2));
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.nameTextField.getText().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        if (this.contractList.getSelectedValuesList().size() == 0) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.contracts"));
            return false;
        }
        if (!this.queryValidation.abilityConditions()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.busquery"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(ProviderWrapper info) {
        this.editingProvider = info;
        this.nameTextField.setText(info.name());
        this.codeTextField.setText(info.code());
        this.supportOfficeTextField.setText(info.supportoffice());
        this.managerOfficeTextField.setText(info.manageroffice());
        this.supportTextField.setText(String.join((CharSequence)", ", info.support()));
        this.managerTextField.setText(String.join((CharSequence)", ", info.manager()));
        this.queryTextField.setText(info.busquery());
        List<String> updated = info.contracts();
        if (updated.size() > 0) {
            this.contractList.setSelectedValue(updated.get(0), true);
            int[] indices = new int[updated.size()];
            int i = 0;
            int k = 0;
            for (String c : this.contracts.keySet()) {
                if (updated.contains(c)) {
                    indices[k] = i;
                    ++k;
                }
                ++i;
            }
            this.contractList.setSelectedIndices(indices);
        }
    }
}

