/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.ApplicationIcons;
import busexplorer.desktop.dialog.CancelAction;
import busexplorer.utils.Language;
import busexplorer.utils.SwingUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public abstract class InputDialog
extends JDialog {
    protected JButton accept;
    protected JButton cancel;
    protected boolean cancelled = true;
    protected boolean hasError;
    private JPanel buttons;
    protected JLabel messageText;
    private Window parentWindow;

    public InputDialog(Window parentWindow) {
        this.setTitle(Language.get(this.getClass(), "title"));
        this.init(parentWindow);
    }

    public InputDialog(Window parentWindow, String title) {
        super(parentWindow, title);
        this.init(parentWindow);
    }

    private void init(Window parentWindow) {
        this.setIconImages(Arrays.asList(ApplicationIcons.BUSEXPLORER_LIST));
        this.parentWindow = parentWindow;
        this.messageText = new JLabel();
        this.messageText.setOpaque(true);
        this.messageText.setFocusable(true);
        this.buttons = this.buildButtons();
    }

    public static int showConfirmDialog(Window parentWindow, String message, String title) {
        final JOptionPane optionPane = new JOptionPane(message, 2, 0);
        final JDialog dialog = optionPane.createDialog(parentWindow, title);
        JButton yes = new JButton();
        yes.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(0);
                dialog.dispose();
            }
        });
        yes.setText(Language.get(InputDialog.class, "confirm.button"));
        yes.setMnemonic(Language.get(InputDialog.class, "confirm.button.mnemonic").charAt(0));
        JButton no = new JButton();
        no.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(1);
                dialog.dispose();
            }
        });
        no.setText(Language.get(CancelAction.class, "name"));
        no.setMnemonic(Language.get(CancelAction.class, "mnemonic").charAt(0));
        SwingUtilities.equalizeComponentSize(yes, no);
        optionPane.setOptions(new Object[]{yes, no});
        optionPane.setInitialValue(yes);
        dialog.getRootPane().setDefaultButton(yes);
        dialog.setVisible(true);
        return (Integer)optionPane.getValue();
    }

    public static JPanel buildButtonPanel(JButton ... buttons) {
        SwingUtilities.equalizeComponentSize(buttons);
        JPanel buttonPanel = new JPanel(new MigLayout("fill, insets 0 0 0 0", "[grow][]"));
        for (JButton button : buttons) {
            buttonPanel.add((Component)button, "gapleft push");
        }
        return buttonPanel;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public JButton getAcceptButton() {
        return this.accept;
    }

    public JButton getCancelButton() {
        return this.cancel;
    }

    @Override
    public Window getOwner() {
        return this.parentWindow;
    }

    public void showDialog() {
        this.getContentPane().add(this.buildMainPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                InputDialog.this.cancelled = true;
                InputDialog.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.parentWindow);
        this.setVisible(true);
    }

    private JPanel buildMainPane() {
        JPanel bottomPanel = new JPanel(new MigLayout("fill, flowy"));
        JScrollPane scrollPane = this.buildErrorMessagePane();
        if (scrollPane != null) {
            bottomPanel.add((Component)scrollPane, "grow, push");
        }
        bottomPanel.add((Component)new JSeparator(0), "grow");
        bottomPanel.add((Component)this.buttons, "grow");
        JPanel panel = new JPanel(new MigLayout("fill, flowy"));
        panel.add((Component)this.buildFields(), "grow");
        panel.add((Component)bottomPanel, "grow, dock south");
        return panel;
    }

    protected JScrollPane buildErrorMessagePane() {
        JScrollPane scrolledMessageText = new JScrollPane(this.messageText);
        scrolledMessageText.setViewportBorder(null);
        scrolledMessageText.setBorder(null);
        scrolledMessageText.setMinimumSize(new Dimension(160, 25));
        return scrolledMessageText;
    }

    private JPanel buildButtons() {
        this.accept = new JButton(this.getString("confirm.button"));
        this.accept.setToolTipText(this.getString("confirm.tooltip"));
        this.accept.setMnemonic(this.getString("confirm.button.mnemonic").charAt(0));
        this.accept.addActionListener(ev -> {
            if (this.acceptActionPerformed()) {
                this.cancelled = false;
                this.dispose();
            }
        });
        JRootPane rp = this.getRootPane();
        rp.setDefaultButton(this.accept);
        this.cancel = new JButton(new CancelAction(this));
        this.cancel.addActionListener(ev -> {
            this.cancelled = true;
        });
        this.cancel.setToolTipText(Language.get(CancelAction.class, "tooltip"));
        this.cancel.setMnemonic(Language.get(CancelAction.class, "mnemonic").charAt(0));
        return InputDialog.buildButtonPanel(this.accept, this.cancel);
    }

    protected String getString(String key) {
        String acceptText = Language.hasKey(this.getClass(), key) ? Language.get(this.getClass(), key) : Language.get(InputDialog.class, key);
        return acceptText;
    }

    public void clearErrorMessage() {
        this.messageText.setText("");
        this.messageText.setIcon(null);
        this.hasError = false;
    }

    public void setErrorMessage(String msg) {
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        this.messageText.setText("  " + msg);
        this.messageText.setIcon(ApplicationIcons.ICON_CANCEL_16);
        this.hasError = true;
    }

    public String getErrorMessage() {
        return this.messageText.getText();
    }

    public boolean hasErrorMessage() {
        return this.hasError;
    }

    protected abstract JPanel buildFields();

    protected abstract boolean accept();

    private boolean acceptActionPerformed() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean result = this.accept();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return result;
    }

    protected abstract boolean hasValidFields();
}

