/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class JMultilineLabel
extends JLabel {
    private String text;
    private Insets margin;
    private int maxWidth;
    private boolean justify;

    public JMultilineLabel() {
        this.setFont(new JLabel().getFont());
        this.margin = new Insets(0, 0, 0, 0);
        this.maxWidth = Integer.MAX_VALUE;
        this.justify = true;
        this.setOpaque(true);
        this.setFocusable(true);
    }

    private void morph() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        String old = this.text;
        this.text = text;
        this.firePropertyChange("text", old, this.text);
        if (old == null ? text != null : !old.equals(text)) {
            this.morph();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        if (maxWidth <= 0) {
            throw new IllegalArgumentException();
        }
        int old = this.maxWidth;
        this.maxWidth = maxWidth;
        this.firePropertyChange("maxWidth", old, this.maxWidth);
        if (old != this.maxWidth) {
            this.morph();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        if (margin == null || margin.top < 0 || margin.left < 0 || margin.right < 0 || margin.bottom < 0) {
            throw new IllegalArgumentException();
        }
        Insets old = this.margin;
        this.margin = margin;
        this.firePropertyChange("margin", old, this.margin);
        if (old != this.margin) {
            this.morph();
        }
    }

    public boolean isJustified() {
        return this.justify;
    }

    public void setJustified(boolean justify) {
        boolean old = this.justify;
        this.justify = justify;
        this.firePropertyChange("justified", old, this.justify);
        if (old != this.justify) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.paintOrGetSize(null, this.getMaxWidth());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintOrGetSize((Graphics2D)g, this.getWidth());
    }

    private Dimension paintOrGetSize(Graphics2D g, int width) {
        Insets insets = this.getInsets();
        float w = insets.left + insets.right + this.margin.left + this.margin.right;
        float x = insets.left + this.margin.left;
        float y = insets.top + this.margin.top;
        if ((width -= insets.left + insets.right + this.margin.left + this.margin.right) == 0) {
            return new Dimension((int)w, (int)y + insets.bottom + this.margin.bottom);
        }
        float max = 0.0f;
        for (String line : JMultilineLabel.split(this.text, '\n')) {
            line = line.isEmpty() ? " " : line;
            AttributedString as = new AttributedString(line);
            as.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator aci = as.getIterator();
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, this.getFontMetrics(this.getFont()).getFontRenderContext());
            while (lbm.getPosition() < aci.getEndIndex()) {
                TextLayout textLayout = lbm.nextLayout(width);
                if (g != null && this.isJustified() && (double)textLayout.getVisibleAdvance() > 0.8 * (double)width) {
                    textLayout = textLayout.getJustifiedLayout(width);
                }
                if (g != null) {
                    textLayout.draw(g, x, y + textLayout.getAscent());
                }
                float last_y = textLayout.getDescent() + textLayout.getLeading() + textLayout.getAscent() + 0.2f;
                y += last_y;
                max = Math.max(max, textLayout.getVisibleAdvance());
            }
        }
        return new Dimension((int)Math.ceil(w += max), (int)Math.ceil(y) + insets.bottom + this.margin.bottom);
    }

    public static List<String> split(String text, char delimiter) {
        ArrayList<String> splitted = new ArrayList<String>();
        int begin = 0;
        int cursor = text.indexOf(delimiter, begin);
        while (cursor > 0) {
            splitted.add(text.substring(begin, cursor));
            begin = cursor + 1;
            cursor = text.indexOf(delimiter, begin);
        }
        if (begin < text.length()) {
            splitted.add(text.substring(begin));
        }
        return splitted;
    }
}

