/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationDeleteAction;
import busexplorer.panel.authorizations.AuthorizationRefreshAction;
import busexplorer.panel.authorizations.AuthorizationTableProvider;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class AuthorizationMissingOffer
extends AuthorizationRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public AuthorizationMissingOffer(JFrame parentWindow) {
        super(parentWindow);
    }

    public AuthorizationMissingOffer(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<AuthorizationWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new AuthorizationDeleteAction((JFrame)this.parentWindow));
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent<AuthorizationWrapper>(new ObjectTableModel<AuthorizationWrapper>(new ArrayList(), new AuthorizationTableProvider()), actions, false, true));
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        BusExplorerTask<List<AuthorizationWrapper>> task = new BusExplorerTask<List<AuthorizationWrapper>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                Map<RegisteredEntityDesc, List<String>> result = Application.login().admin.getAuthorizations();
                int size = result.size();
                ArrayList offers = (ArrayList)OfferWrapper.convertToInfo(Application.login().admin.getOffers());
                Iterator<Map.Entry<RegisteredEntityDesc, List<String>>> itAuths = result.entrySet().iterator();
                while (itAuths.hasNext()) {
                    Map.Entry<RegisteredEntityDesc, List<String>> entryAuthorization = itAuths.next();
                    String entityName = entryAuthorization.getKey().id;
                    List<String> grantedInterfaces = entryAuthorization.getValue();
                    Iterator itOffer = offers.iterator();
                    while (itOffer.hasNext()) {
                        OfferWrapper offer = (OfferWrapper)itOffer.next();
                        if (!entityName.equals(offer.getEntityId())) continue;
                        grantedInterfaces.removeAll(offer.getInterfaces());
                        itOffer.remove();
                        if (!grantedInterfaces.isEmpty()) continue;
                        itAuths.remove();
                        break;
                    }
                    this.setProgressStatus(100 * i / size);
                    ++i;
                }
                this.setResult(AuthorizationWrapper.convertToInfo(result));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = AuthorizationMissingOffer.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && AuthorizationMissingOffer.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        AuthorizationMissingOffer.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

