/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.interfaces;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.interfaces.InterfaceWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class InterfaceInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel interfaceNameLabel;
    private JTextField interfaceNameField;
    private TablePanelComponent<InterfaceWrapper> panel;

    public InterfaceInputDialog(Window parentWindow, TablePanelComponent<InterfaceWrapper> panel) {
        super(parentWindow);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                Application.login().admin.createInterface(InterfaceInputDialog.this.getInterfaceName());
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    InterfaceWrapper wrapper = new InterfaceWrapper(InterfaceInputDialog.this.getInterfaceName());
                    InterfaceInputDialog.this.panel.refresh(null);
                    InterfaceInputDialog.this.panel.selectElement(wrapper, true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(450, 185));
        JPanel panel = new JPanel(new MigLayout("fill, flowy"));
        this.interfaceNameLabel = new JLabel(Language.get(this.getClass(), "interfaceName.label"));
        panel.add((Component)this.interfaceNameLabel, "grow");
        this.interfaceNameField = new JTextField(30);
        this.interfaceNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (InterfaceInputDialog.this.interfaceNameField.getText().trim().isEmpty()) {
                    InterfaceInputDialog.this.setErrorMessage(Language.get(InterfaceInputDialog.class, "error.validation.name"));
                } else {
                    InterfaceInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.interfaceNameField, "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        String interfaceName = this.interfaceNameField.getText().trim();
        if (interfaceName.isEmpty() || !interfaceName.startsWith("IDL:")) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    private String getInterfaceName() {
        return this.interfaceNameField.getText();
    }
}

