/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.offers;

import busexplorer.Application;
import busexplorer.utils.Availability;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Profile;
import scs.core.IComponent;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;

public class OfferWrapper {
    public static final String OPENBUS_COMPONENT_INTERFACE = "openbus.component.interface";
    private ServiceOfferDesc desc;
    private final String entity;
    private final String id;
    private final Vector<String> interfaces;
    private final Date date;
    private final String name;
    private final String version;
    private Availability availability = new Availability(Availability.Status.UNKNOWN);

    public OfferWrapper(ServiceOfferDesc desc) {
        this.desc = desc;
        this.entity = OfferWrapper.getProperty(desc, "openbus.offer.entity");
        this.id = OfferWrapper.getProperty(desc, "openbus.offer.id");
        this.interfaces = OfferWrapper.getProperties(desc, OPENBUS_COMPONENT_INTERFACE);
        int year = Integer.parseInt(OfferWrapper.getProperty(desc, "openbus.offer.year"));
        int month = Integer.parseInt(OfferWrapper.getProperty(desc, "openbus.offer.month")) - 1;
        int day = Integer.parseInt(OfferWrapper.getProperty(desc, "openbus.offer.day"));
        int hour = Integer.parseInt(OfferWrapper.getProperty(desc, "openbus.offer.hour"));
        int min = Integer.parseInt(OfferWrapper.getProperty(desc, "openbus.offer.minute"));
        int sec = Integer.parseInt(OfferWrapper.getProperty(desc, "openbus.offer.second"));
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, min, sec);
        this.date = calendar.getTime();
        this.name = OfferWrapper.getProperty(desc, "openbus.component.name");
        String version = OfferWrapper.getProperty(desc, "openbus.component.version.major");
        version = version + "." + OfferWrapper.getProperty(desc, "openbus.component.version.minor");
        this.version = version = version + "." + OfferWrapper.getProperty(desc, "openbus.component.version.patch");
    }

    public static String getProperty(ServiceOfferDesc offer, String prop) {
        ServiceProperty[] properties;
        for (ServiceProperty property : properties = offer.properties) {
            if (!property.name.equals(prop)) continue;
            return property.value;
        }
        return null;
    }

    public static Vector<String> getProperties(ServiceOfferDesc offer, String prop) {
        ServiceProperty[] properties;
        Vector<String> list = new Vector<String>();
        for (ServiceProperty property : properties = offer.properties) {
            if (!property.name.equals(prop)) continue;
            list.add(property.value);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OfferWrapper)) {
            return false;
        }
        OfferWrapper other = (OfferWrapper)o;
        return this.entity.equals(other.entity) && this.id.equals(other.id);
    }

    public int hashCode() {
        return this.entity.hashCode() ^ this.id.hashCode();
    }

    public String getEntityId() {
        return this.entity;
    }

    public Vector<String> getInterfaces() {
        return this.interfaces;
    }

    public Date getDate() {
        return this.date;
    }

    public ServiceOfferDesc getDescriptor() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static List<OfferWrapper> convertToInfo(List<ServiceOfferDesc> offers) {
        ArrayList<OfferWrapper> list = new ArrayList<OfferWrapper>();
        for (ServiceOfferDesc offer : offers) {
            list.add(new OfferWrapper(offer));
        }
        return list;
    }

    public Vector<String> getEndpoints() {
        ArrayList<String> results = new ArrayList<String>();
        IComponent comp = this.getDescriptor().service_ref;
        ORB orb = (ORB)Application.login().getORB();
        ParsedIOR ior = new ParsedIOR(orb, orb.object_to_string(comp));
        for (Profile profile : ior.getProfiles()) {
            IIOPAddress address = (IIOPAddress)((IIOPProfile)profile).getAddress();
            String endpoint = String.format("%s:%s", address.getOriginalHost(), address.getPort());
            if (results.contains(endpoint)) continue;
            results.add(endpoint);
        }
        return new Vector<String>(results);
    }

    public Availability getStatus() {
        return this.availability;
    }

    public void updateStatus(Availability.Status status, Exception exception) {
        this.availability.status = status;
        this.availability.detail = exception != null ? exception.getMessage() : "";
    }
}

