/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Date;
import javax.net.SocketFactory;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;

public class SSLSocketFactory
extends AbstractSocketFactory {
    private SocketFactory factory = null;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private boolean trusteesFromKS = false;
    private int clientSupportedOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private final SSLSessionListener sslListener;
    private SSLRandom sslRandom;
    private String keystore_type = null;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    private String keystore_provider = null;
    private String truststore_type = null;
    private String truststore_location = null;
    private String truststore_passphrase = null;
    private String truststore_provider = null;
    private boolean support_crl = false;
    private String crl_file = null;

    public SSLSocketFactory(ORB orb) {
        this.sslListener = orb.getTransportManager().getSocketFactoryManager().getSSLListener();
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        block6: {
            super.configure(configuration);
            this.sslRandom = new SSLRandom();
            this.sslRandom.configure(configuration);
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password");
            this.keystore_type = configuration.getAttribute("jacorb.security.keystore_type", "JKS");
            this.keystore_provider = configuration.getAttribute("jacorb.security.keystore_provider", null);
            this.truststore_type = configuration.getAttribute("jacorb.security.truststore_type", null);
            this.truststore_location = configuration.getAttribute("jacorb.security.truststore", null);
            this.truststore_passphrase = configuration.getAttribute("jacorb.security.truststore_password", null);
            this.truststore_provider = configuration.getAttribute("jacorb.security.truststore_provider", null);
            this.crl_file = configuration.getAttribute("jacorb.security.crl_file", null);
            this.support_crl = configuration.getAttributeAsBoolean("jacorb.security.support_crl", false);
            this.keyManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.client.key_manager_algorithm", "SunX509");
            this.trustManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.client.trust_manager_algorithm", "SunX509");
            this.clientSupportedOptions = configuration.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 0, 16);
            try {
                this.trustManager = (TrustManager)configuration.getAttributeAsObject("jacorb.security.ssl.client.trust_manager");
            }
            catch (ConfigurationException e) {
                if (!this.logger.isErrorEnabled()) break block6;
                this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.client.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.client.trust_manager", ""), e);
            }
        }
        if (configuration.getAttribute("jacorb.security.ssl.client.protocols", null) != null) {
            this.enabledProtocols = configuration.getAttributeAsStringsArray("jacorb.security.ssl.server.protocols");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified client enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.client.protocols", ""));
            }
        }
        try {
            this.factory = this.createSocketFactory();
        }
        catch (Exception e) {
            this.logger.error("Unable to create SSLSocketFactory!", e);
            throw new ConfigurationException("Unable to create SSLSocketFactory!", e);
        }
        this.cipher_suites = configuration.getAttributeAsStringsArray("jacorb.security.ssl.client.cipher_suites");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port);
        this.initSSLSocket(socket);
        return socket;
    }

    @Override
    protected Socket doCreateSocket(String host, int port, int timeout) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket();
        socket.connect(new InetSocketAddress(host, port), timeout);
        this.initSSLSocket(socket);
        return socket;
    }

    private void initSSLSocket(SSLSocket socket) {
        if (this.cipher_suites != null) {
            socket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            socket.setEnabledProtocols(this.enabledProtocols);
        }
        socket.addHandshakeCompletedListener(new SSLHandshakeListener(this.logger, this.sslListener));
    }

    @Override
    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        KeyManagerFactory kmf = null;
        KeyStore key_store = null;
        if (this.trusteesFromKS || (this.clientSupportedOptions & 0x40) != 0) {
            key_store = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray(), this.keystore_type, this.keystore_provider);
            if ((this.clientSupportedOptions & 0x40) != 0) {
                kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
                if ("WINDOWS-MY".equalsIgnoreCase(this.keystore_type)) {
                    kmf.init(key_store, null);
                } else {
                    kmf.init(key_store, this.keystore_passphrase.toCharArray());
                }
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        KeyStore trust_store = null;
        if (this.trusteesFromKS) {
            trust_store = key_store;
        } else if ("PKCS11".equalsIgnoreCase(this.truststore_type)) {
            trust_store = KeyStore.getInstance(this.truststore_type, this.truststore_provider);
            trust_store.load(null, this.truststore_passphrase.toCharArray());
        } else if ("WINDOWS-ROOT".equalsIgnoreCase(this.truststore_type)) {
            trust_store = KeyStore.getInstance("WINDOWS-ROOT");
            trust_store.load(null, null);
        } else if (this.truststore_location != null && this.truststore_passphrase != null) {
            trust_store = KeyStoreUtil.getKeyStore(this.truststore_location, this.truststore_passphrase.toCharArray(), this.truststore_type, this.truststore_provider);
        }
        if (trust_store != null && this.logger.isInfoEnabled()) {
            this.logger.info("Loading trusted certs from keystore " + trust_store.getType());
        }
        if (trust_store != null && this.support_crl) {
            PKIXBuilderParameters pkixParams = null;
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setCertificateValid(new Date());
            pkixParams = new PKIXBuilderParameters(trust_store, (CertSelector)x509CertSelector);
            FileInputStream crlFileStream = new FileInputStream(this.crl_file);
            boolean[] keyUsage = new boolean[]{true};
            x509CertSelector.setKeyUsage(keyUsage);
            CertificateFactory crlf = CertificateFactory.getInstance("X.509");
            X509CRL x509crl = (X509CRL)crlf.generateCRL(crlFileStream);
            ArrayList<X509CRL> list = new ArrayList<X509CRL>();
            list.add(x509crl);
            CollectionCertStoreParameters cparam = new CollectionCertStoreParameters(list);
            CertStore cs = CertStore.getInstance("Collection", cparam);
            pkixParams.setRevocationEnabled(true);
            pkixParams.addCertStore(cs);
            CertPathTrustManagerParameters trustParams = new CertPathTrustManagerParameters(pkixParams);
            tmf.init(trustParams);
        } else {
            tmf.init(trust_store);
        }
        if (this.trustManager == null) {
            trustManagers = tmf.getTrustManagers();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified TrustManager for the client: " + this.trustManager.getClass().getName());
            }
            trustManagers = new TrustManager[]{this.trustManager};
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf == null ? null : kmf.getKeyManagers(), trustManagers, this.sslRandom.getSecureRandom());
        return ctx.getSocketFactory();
    }
}

