/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.japura.gui.AbstractComboBox;
import org.japura.gui.BatchSelection;
import org.japura.gui.CheckList;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.model.DefaultListCheckModel;
import org.japura.gui.model.ListCheckModel;
import org.japura.gui.renderer.CheckListRenderer;

public class CheckComboBox
extends AbstractComboBox {
    private static final long serialVersionUID = 8289247356412690742L;
    public static final CheckState NONE = CheckState.NONE;
    public static final CheckState MULTIPLE = CheckState.MULTIPLE;
    public static final CheckState ALL = CheckState.ALL;
    private JScrollPane scrollPane;
    private CheckList checkList;
    private ListDataListener listDataListener;
    private ListCheckListener listCheckListener;
    private int visibleRowCount = 8;
    private HashMap<CheckState, String> texts = new HashMap();

    public CheckComboBox() {
        this.setRenderer(new CheckListRenderer());
        this.setModel(new DefaultListCheckModel());
    }

    public void setRenderer(CheckListRenderer renderer) {
        this.getCheckList().setCellRenderer(renderer);
        this.updateCellPanelWidth();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = Math.max(3, visibleRowCount);
        this.getCheckList().setVisibleRowCount(this.getVisibleRowCount());
    }

    @Override
    public void setPopupVisible(boolean visible) {
        if (visible) {
            if (this.getModel().getSize() > 0) {
                int rows = Math.min(this.getVisibleRowCount(), this.getModel().getSize());
                this.getCheckList().setVisibleRowCount(rows);
                this.getCheckList().setPreferredSize(null);
                Dimension pSize = this.getCheckList().getPreferredSize();
                Dimension dim = this.getSize();
                if (pSize.width < dim.width) {
                    this.getCheckList().setPreferredSize(new Dimension(dim.width, pSize.height));
                }
                this.getPopup().show(this, 0, dim.height);
            }
        } else {
            this.getPopup().setVisible(false);
        }
    }

    @Override
    protected void unregisterEmbeddedComponent(JComponent oldEmbeddedComponent) {
        if (oldEmbeddedComponent instanceof BatchSelection) {
            BatchSelection bs = (BatchSelection)oldEmbeddedComponent;
            bs.unregisterModel();
        }
    }

    @Override
    protected void registerEmbeddedComponent(JComponent newEmbeddedComponent) {
        if (newEmbeddedComponent instanceof BatchSelection) {
            BatchSelection bs = (BatchSelection)newEmbeddedComponent;
            bs.registerModel(this.getModel());
        }
    }

    public void setModel(ListCheckModel model) {
        this.getCheckList().setModel(model);
        model.removeListDataListener(this.getListDataListener());
        model.removeListCheckListener(this.getListCheckListener());
        model.addListDataListener(this.getListDataListener());
        model.addListCheckListener(this.getListCheckListener());
        if (this.getEmbeddedComponent() != null) {
            JComponent comp = this.getEmbeddedComponent().getComponent();
            this.unregisterEmbeddedComponent(comp);
            this.registerEmbeddedComponent(comp);
        }
        this.updateCellPanelWidth();
    }

    public ListCheckModel getModel() {
        return this.getCheckList().getModel();
    }

    protected void updateCellPanelWidth() {
        if (this.getPrototypeDisplayValue() != null) {
            this.getComboBox().setPrototypeDisplayValue(this.getPrototypeDisplayValue());
            return;
        }
        String value = null;
        for (CheckState checkState : CheckState.values()) {
            String text = this.getTextFor(checkState);
            if (text == null) continue;
            if (value == null) {
                value = text;
                continue;
            }
            if (text.length() <= value.length()) continue;
            value = text;
        }
        ListCheckModel m = this.getModel();
        for (int i = 0; i < m.getSize(); ++i) {
            String str = m.getElementAt(i).toString();
            if (value == null) {
                value = str;
                continue;
            }
            if (str.length() <= value.length()) continue;
            value = str;
        }
        this.getComboBox().setPrototypeDisplayValue(value);
    }

    private CheckList getCheckList() {
        if (this.checkList == null) {
            this.checkList = new CheckList();
        }
        return this.checkList;
    }

    private ListCheckListener getListCheckListener() {
        if (this.listCheckListener == null) {
            this.listCheckListener = new ListCheckListener(){

                @Override
                public void addCheck(ListEvent event) {
                    CheckComboBox.this.updateComboBox();
                }

                @Override
                public void removeCheck(ListEvent event) {
                    CheckComboBox.this.updateComboBox();
                }
            };
        }
        return this.listCheckListener;
    }

    @Override
    protected void updateComboBox() {
        this.getComboBox().removeAllItems();
        CheckListRenderer renderer = this.getCheckList().getCellRenderer();
        List<Object> checkeds = this.getModel().getCheckeds();
        int total = this.getModel().getSize();
        if (total > 0) {
            if (checkeds.size() == 0 && this.texts.containsKey((Object)CheckState.NONE)) {
                this.getComboBox().addItem(this.getTextFor(CheckState.NONE));
            } else if (checkeds.size() == 1) {
                this.getComboBox().addItem(renderer.getText(checkeds.get(0)));
            } else if (checkeds.size() == total && this.texts.containsKey((Object)CheckState.ALL)) {
                this.getComboBox().addItem(this.getTextFor(CheckState.ALL));
            } else if (checkeds.size() > 1 && this.texts.containsKey((Object)CheckState.MULTIPLE)) {
                this.getComboBox().addItem(this.getTextFor(CheckState.MULTIPLE));
            }
        }
    }

    private ListDataListener getListDataListener() {
        if (this.listDataListener == null) {
            this.listDataListener = new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent e) {
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    CheckComboBox.this.updateComboBox();
                    CheckComboBox.this.updateCellPanelWidth();
                    CheckComboBox.this.repaint();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    CheckComboBox.this.updateComboBox();
                    CheckComboBox.this.updateCellPanelWidth();
                    CheckComboBox.this.repaint();
                }
            };
        }
        return this.listDataListener;
    }

    public String getTextFor(CheckState checkState) {
        if (checkState != null) {
            return this.texts.get((Object)checkState);
        }
        return null;
    }

    public void removeTextFor(CheckState checkState) {
        if (checkState != null) {
            this.texts.remove((Object)checkState);
            if (checkState.equals((Object)NONE)) {
                this.updateComboBox();
            }
        }
    }

    public void setTextFor(CheckState checkState, String text) {
        if (checkState == null) {
            return;
        }
        if (text == null) {
            text = "";
        }
        this.texts.put(checkState, text);
        if (checkState.equals((Object)NONE)) {
            this.updateComboBox();
        }
        this.updateCellPanelWidth();
        this.repaint();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
            this.scrollPane.setViewportView(this.getCheckList());
        }
        return this.scrollPane;
    }

    @Override
    protected JComponent getPopupComponent() {
        return this.getScrollPane();
    }

    public static enum CheckState {
        NONE,
        ALL,
        MULTIPLE;

    }
}

