/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.japura.gui.renderer.SplitButtonRenderer;

public class DefaultSplitButtonRenderer
implements SplitButtonRenderer {
    private JLabel label = new JLabel();
    private JSeparator separator = new JSeparator();
    private Border mouseOverBorder;
    private Border mouseOutBorder;

    public DefaultSplitButtonRenderer() {
        this.separator.setBackground(Color.WHITE);
        this.label.setOpaque(true);
    }

    @Override
    public Component getCellRendererComponent(String buttonName, boolean isSeparator, boolean cellHasFocus, boolean buttonEnabled) {
        if (isSeparator) {
            return this.separator;
        }
        this.label.setText(buttonName);
        if (!buttonEnabled) {
            this.label.setBorder(this.getMouseOutBorder());
            this.label.setBackground(Color.WHITE);
            this.label.setForeground(Color.LIGHT_GRAY);
        } else if (cellHasFocus) {
            this.label.setBorder(this.getMouseOverBorder());
            this.label.setBackground(Color.BLACK);
            this.label.setForeground(Color.WHITE);
        } else {
            this.label.setBorder(this.getMouseOutBorder());
            this.label.setBackground(Color.WHITE);
            this.label.setForeground(Color.BLACK);
        }
        return this.label;
    }

    public Border getMouseOverBorder() {
        if (this.mouseOverBorder == null) {
            this.mouseOverBorder = BorderFactory.createLineBorder(Color.BLACK, 3);
        }
        return this.mouseOverBorder;
    }

    public Border getMouseOutBorder() {
        if (this.mouseOutBorder == null) {
            this.mouseOutBorder = BorderFactory.createLineBorder(Color.WHITE, 3);
        }
        return this.mouseOutBorder;
    }
}

