/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.externalcommand;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Timer;
import java.util.TimerTask;

public class ExternalCommand {
    private Process process;
    private String stdoutContent = null;
    private String stderrContent = null;
    private final String[] cmdArray;
    private final String command;
    private String[] envp;
    private File workingDir;
    private int exitValue = Integer.MAX_VALUE;
    private Thread stdOutReader;
    private Thread stdErrReader;

    public ExternalCommand(String[] cmdArray) {
        this(null, cmdArray, null, null);
    }

    public ExternalCommand(String[] cmdArray, String[] envp, File workingDir) {
        this(null, cmdArray, envp, workingDir);
    }

    public ExternalCommand(String command) {
        this(command, null, null, null);
    }

    public ExternalCommand(String command, String[] envp, File workingDir) {
        this(command, null, envp, workingDir);
    }

    private ExternalCommand(String command, String[] cmdArray, String[] envp, File workingDir) {
        this.command = command;
        this.cmdArray = cmdArray;
        this.envp = envp;
        this.workingDir = workingDir;
    }

    private void startProcess(final boolean keepStdout, final boolean keepStderr) throws IOException {
        if (this.process != null) {
            throw new IllegalStateException("este comando j\u00e1 foi executado");
        }
        this.process = this.cmdArray != null ? Runtime.getRuntime().exec(this.cmdArray, this.envp, this.workingDir) : Runtime.getRuntime().exec(this.command, this.envp, this.workingDir);
        this.stdOutReader = this.startReaderThread("StdoutReaderThread", new Runnable(){

            @Override
            public void run() {
                ExternalCommand.this.stdoutContent = ExternalCommand.readContent(ExternalCommand.this.process.getInputStream(), keepStdout);
            }
        });
        this.stdErrReader = this.startReaderThread("StderrReaderThread", new Runnable(){

            @Override
            public void run() {
                ExternalCommand.this.stderrContent = ExternalCommand.readContent(ExternalCommand.this.process.getErrorStream(), keepStderr);
            }
        });
    }

    private Thread startReaderThread(String name, Runnable runnable) {
        Thread thread = new Thread(runnable, name);
        thread.start();
        return thread;
    }

    public int waitFor(boolean keepStdout, boolean keepStderr) throws InterruptedException, IOException {
        this.startProcess(keepStdout, keepStderr);
        this.waitForProcessAndStreams();
        return this.exitValue;
    }

    private void waitForProcessAndStreams() throws InterruptedException {
        this.exitValue = this.process.waitFor();
        this.stdOutReader.join();
        this.stdErrReader.join();
    }

    public int waitFor() throws InterruptedException, IOException {
        return this.waitFor(true, true);
    }

    public synchronized int waitFor(boolean keepStdout, boolean keepStderr, long timeout) throws IOException, InterruptedException {
        this.startProcess(keepStdout, keepStderr);
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptScheduler(Thread.currentThread()), timeout);
        try {
            this.waitForProcessAndStreams();
        }
        catch (InterruptedException e) {
            String fmt = "Timeout na execu\u00e7\u00e3o do comando '%s'! (Causa '%s')";
            String cmd = this.command == null ? "null" : this.command;
            String msg = String.format(fmt, cmd, e.getMessage());
            throw new InterruptedException(msg);
        }
        finally {
            timer.cancel();
            this.process.destroy();
        }
        return this.exitValue;
    }

    public int waitFor(long timeout) throws InterruptedException, IOException {
        return this.waitFor(true, true, timeout);
    }

    public String getStandardOutput() {
        this.checkExecuted();
        return this.stdoutContent;
    }

    private void checkExecuted() {
        if (this.exitValue == Integer.MAX_VALUE) {
            throw new IllegalStateException("o comando ainda n\u00e3o foi executado");
        }
    }

    public String getStandardOutput(int firstLine, int lastLine) {
        return ExternalCommand.readLinesFromString(this.getStandardOutput(), firstLine, lastLine);
    }

    public String getStandardOutput(int line) {
        return ExternalCommand.readLinesFromString(this.getStandardOutput(), line, line);
    }

    public String getErrorOutput() {
        this.checkExecuted();
        return this.stderrContent;
    }

    public String getErrorOutput(int firstLine, int lastLine) {
        return ExternalCommand.readLinesFromString(this.getErrorOutput(), firstLine, lastLine);
    }

    public String getErrorOutput(int line) {
        return ExternalCommand.readLinesFromString(this.getErrorOutput(), line, line);
    }

    private static String readLinesFromString(String str, int firstLine, int lastLine) {
        if (firstLine > lastLine) {
            throw new IllegalArgumentException("firstLine > lastLine");
        }
        if (str == null) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        String line = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(str));){
            for (int i = 0; i <= lastLine && (line = reader.readLine()) != null; ++i) {
                if (i < firstLine) continue;
                if (i > firstLine) {
                    content.append('\n');
                }
                content.append(line);
            }
        }
        catch (IOException e) {
            return null;
        }
        return content.toString();
    }

    private static String readContent(InputStream inputStream, boolean keepContent) {
        StringBuilder content = new StringBuilder();
        String tmp = null;
        int i = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            while ((tmp = reader.readLine()) != null) {
                if (!keepContent) continue;
                if (i++ > 0) {
                    content.append('\n');
                }
                content.append(tmp);
            }
            inputStream.close();
        }
        catch (IOException e) {
            return null;
        }
        return content.toString();
    }

    public int exitValue() {
        this.checkExecuted();
        return this.exitValue;
    }

    public void destroy() {
        this.checkExecuted();
        this.process.destroy();
    }

    private class InterruptScheduler
    extends TimerTask {
        Thread target = null;

        public InterruptScheduler(Thread target) {
            this.target = target;
        }

        @Override
        public void run() {
            this.target.interrupt();
        }
    }
}

