/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdminFacade;
import tecgraf.openbus.admin.IncompatibleBus;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistryHelper;
import tecgraf.openbus.core.v2_1.services.access_control.admin.v1_0.CertificateRegistry;
import tecgraf.openbus.core.v2_1.services.access_control.admin.v1_0.CertificateRegistryHelper;
import tecgraf.openbus.core.v2_1.services.access_control.admin.v1_0.InvalidCertificate;
import tecgraf.openbus.core.v2_1.services.admin.v1_0.Configuration;
import tecgraf.openbus.core.v2_1.services.admin.v1_0.ConfigurationHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.AuthorizationInUse;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityAlreadyRegistered;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategory;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategoryAlreadyExists;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategoryDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategoryInUse;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityRegistry;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityRegistryHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.InterfaceInUse;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.InterfaceRegistry;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.InterfaceRegistryHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.InvalidInterface;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntity;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class BusAdminImpl
implements BusAdminFacade {
    private final Object reference;
    private EntityRegistry entityRegistry;
    private CertificateRegistry certificateRegistry;
    private InterfaceRegistry interfaceRegistry;
    private OfferRegistry offerRegistry;
    private LoginRegistry loginRegistry;
    private Configuration configuration = null;

    public BusAdminImpl(Object reference) {
        this.reference = reference;
        this.setRegistries();
    }

    @Override
    public List<EntityCategoryDesc> getCategories() throws ServiceFailure {
        EntityCategoryDesc[] array = this.entityRegistry.getEntityCategories();
        return new ArrayList<EntityCategoryDesc>(Arrays.asList(array));
    }

    @Override
    public EntityCategory createCategory(String categoryID, String categoryName) throws ServiceFailure, UnauthorizedOperation, EntityCategoryAlreadyExists {
        return this.entityRegistry.createEntityCategory(categoryID, categoryName);
    }

    @Override
    public void removeCategory(String categoryID) throws ServiceFailure, UnauthorizedOperation, EntityCategoryInUse {
        EntityCategory category = this.entityRegistry.getEntityCategory(categoryID);
        category.remove();
    }

    @Override
    public List<RegisteredEntityDesc> getEntities() throws ServiceFailure {
        RegisteredEntityDesc[] array = this.entityRegistry.getEntities();
        return new ArrayList<RegisteredEntityDesc>(Arrays.asList(array));
    }

    @Override
    public RegisteredEntity createEntity(String entityID, String entityName, String categoryID) throws ServiceFailure, UnauthorizedOperation, EntityAlreadyRegistered {
        EntityCategory category = this.entityRegistry.getEntityCategory(categoryID);
        return category.registerEntity(entityID, entityName);
    }

    @Override
    public RegisteredEntity getEntity(String entityID) throws ServiceFailure {
        return this.entityRegistry.getEntity(entityID);
    }

    @Override
    public boolean removeEntity(String entityID) throws ServiceFailure, UnauthorizedOperation {
        RegisteredEntity entity = this.getEntity(entityID);
        if (entity != null) {
            entity.remove();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getEntitiesWithCertificate() throws ServiceFailure, UnauthorizedOperation {
        String[] array = this.certificateRegistry.getEntitiesWithCertificate();
        return new ArrayList<String>(Arrays.asList(array));
    }

    @Override
    public void registerCertificate(String entityID, byte[] certificate) throws ServiceFailure, UnauthorizedOperation, InvalidCertificate {
        this.certificateRegistry.registerCertificate(entityID, certificate);
    }

    @Override
    public void removeCertificate(String entityID) throws ServiceFailure, UnauthorizedOperation {
        this.certificateRegistry.removeCertificate(entityID);
    }

    @Override
    public List<String> getInterfaces() throws ServiceFailure {
        String[] array = this.interfaceRegistry.getInterfaces();
        return new ArrayList<String>(Arrays.asList(array));
    }

    @Override
    public boolean createInterface(String interfaceName) throws ServiceFailure, UnauthorizedOperation, InvalidInterface {
        return this.interfaceRegistry.registerInterface(interfaceName);
    }

    @Override
    public void removeInterface(String interfaceName) throws ServiceFailure, UnauthorizedOperation, InterfaceInUse {
        this.interfaceRegistry.removeInterface(interfaceName);
    }

    @Override
    public Map<RegisteredEntityDesc, List<String>> getAuthorizations() throws ServiceFailure {
        RegisteredEntityDesc[] entitiesDesc;
        LinkedHashMap<RegisteredEntityDesc, List<String>> map = new LinkedHashMap<RegisteredEntityDesc, List<String>>();
        for (RegisteredEntityDesc entityDesc : entitiesDesc = this.entityRegistry.getAuthorizedEntities()) {
            map.put(entityDesc, new ArrayList<String>(Arrays.asList(entityDesc.ref.getGrantedInterfaces())));
        }
        return map;
    }

    @Override
    public boolean setAuthorization(String entityID, String interfaceName) throws ServiceFailure, UnauthorizedOperation, InvalidInterface {
        RegisteredEntity entity = this.getEntity(entityID);
        return entity.grantInterface(interfaceName);
    }

    @Override
    public void revokeAuthorization(String entityID, String interfaceName) throws ServiceFailure, UnauthorizedOperation, InvalidInterface, AuthorizationInUse {
        RegisteredEntity entity = this.getEntity(entityID);
        entity.revokeInterface(interfaceName);
    }

    @Override
    public List<ServiceOfferDesc> getOffers() throws ServiceFailure {
        ServiceOfferDesc[] array = this.offerRegistry.getAllServices();
        return new ArrayList<ServiceOfferDesc>(Arrays.asList(array));
    }

    @Override
    public void removeOffer(ServiceOfferDesc desc) throws ServiceFailure, UnauthorizedOperation {
        desc.ref.remove();
    }

    @Override
    public List<LoginInfo> getLogins() throws ServiceFailure, UnauthorizedOperation {
        LoginInfo[] array = this.loginRegistry.getAllLogins();
        return new ArrayList<LoginInfo>(Arrays.asList(array));
    }

    @Override
    public void invalidateLogin(LoginInfo loginInfo) throws ServiceFailure, UnauthorizedOperation {
        this.loginRegistry.invalidateLogin(loginInfo.id);
    }

    @Override
    public boolean isReconfigurationCapable() {
        return this.configuration != null;
    }

    @Override
    public void reloadConfigsFile() throws ServiceFailure, UnauthorizedOperation {
        this.configuration.reloadConfigsFile();
    }

    @Override
    public void grantAdminTo(List<String> users) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.grantAdminTo(users.toArray(new String[users.size()]));
    }

    @Override
    public void revokeAdminFrom(List<String> users) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.revokeAdminFrom(users.toArray(new String[users.size()]));
    }

    @Override
    public List<String> getAdmins() throws ServiceFailure {
        String[] admins = this.configuration.getAdmins();
        ArrayList<String> ret = new ArrayList<String>();
        Collections.addAll(ret, admins);
        return ret;
    }

    @Override
    public void addPasswordValidator(String validator) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.addPasswordValidator(validator);
    }

    @Override
    public void delPasswordValidator(String validator) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.delPasswordValidator(validator);
    }

    @Override
    public List<String> getPasswordValidators() throws ServiceFailure {
        String[] validators = this.configuration.getPasswordValidators();
        ArrayList<String> ret = new ArrayList<String>();
        Collections.addAll(ret, validators);
        return ret;
    }

    @Override
    public void setMaxChannels(int maxchannels) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.setMaxChannels(maxchannels);
    }

    @Override
    public int getMaxChannels() throws ServiceFailure {
        return this.configuration.getMaxChannels();
    }

    @Override
    public void setMaxCacheSize(int maxcachesize) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.setMaxCacheSize(maxcachesize);
    }

    @Override
    public int getMaxCacheSize() throws ServiceFailure {
        return this.configuration.getMaxCacheSize();
    }

    @Override
    public void setCallsTimeout(int timeout) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.setCallsTimeout(timeout);
    }

    @Override
    public int getCallsTimeout() throws ServiceFailure {
        return this.configuration.getCallsTimeout();
    }

    @Override
    public void setLogLevel(short loglevel) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.setLogLevel(loglevel);
    }

    @Override
    public short getLogLevel() throws ServiceFailure {
        return this.configuration.getLogLevel();
    }

    @Override
    public void setOilLogLevel(short oilLoglevel) throws ServiceFailure, UnauthorizedOperation {
        this.configuration.setOilLogLevel(oilLoglevel);
    }

    @Override
    public short getOilLogLevel() throws ServiceFailure {
        return this.configuration.getOilLogLevel();
    }

    public Object getBusReference() {
        return this.reference;
    }

    private void setRegistries() {
        IComponent iComponent = IComponentHelper.narrow(this.getBusReference());
        if (iComponent == null) {
            throw new IncompatibleBus(LNG.get("IncompatibleBus.missing.icomponent"));
        }
        Object entityRegistryObj = iComponent.getFacet(EntityRegistryHelper.id());
        if (entityRegistryObj == null) {
            throw new IncompatibleBus(LNG.get("IncompatibleBus.error.entityregistry"));
        }
        this.entityRegistry = EntityRegistryHelper.narrow(entityRegistryObj);
        Object certificateRegistryObj = iComponent.getFacet(CertificateRegistryHelper.id());
        if (certificateRegistryObj == null) {
            throw new IncompatibleBus(LNG.get("IncompatibleBus.error.certificateregistry"));
        }
        this.certificateRegistry = CertificateRegistryHelper.narrow(certificateRegistryObj);
        Object interfaceRegistryObj = iComponent.getFacet(InterfaceRegistryHelper.id());
        if (interfaceRegistryObj == null) {
            throw new IncompatibleBus(LNG.get("IncompatibleBus.error.interfaceregistry"));
        }
        this.interfaceRegistry = InterfaceRegistryHelper.narrow(interfaceRegistryObj);
        Object offerRegistryObj = iComponent.getFacet(OfferRegistryHelper.id());
        if (offerRegistryObj == null) {
            throw new IncompatibleBus(LNG.get("IncompatibleBus.error.offerregistry"));
        }
        this.offerRegistry = OfferRegistryHelper.narrow(offerRegistryObj);
        Object loginRegistryObj = iComponent.getFacet(LoginRegistryHelper.id());
        if (loginRegistryObj == null) {
            throw new IncompatibleBus(LNG.get("IncompatibleBus.error.loginregistry"));
        }
        this.loginRegistry = LoginRegistryHelper.narrow(loginRegistryObj);
        Object configurationObj = iComponent.getFacet(ConfigurationHelper.id());
        if (configurationObj != null) {
            this.configuration = ConfigurationHelper.narrow(configurationObj);
        }
    }
}

