/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.security.interfaces.RSAPrivateKey;
import tecgraf.openbus.SharedAuthSecret;

public class AuthArgs {
    AuthMode mode;
    String entity;
    byte[] password;
    String domain;
    RSAPrivateKey privkey;
    SharedAuthSecret secret;

    public AuthArgs(String entity, byte[] password, String domain) {
        if (entity == null || password == null || domain == null) {
            throw new IllegalArgumentException("Entidade, senha e dom\u00ednio devem ser diferentes de nulo.");
        }
        this.entity = entity;
        this.password = password;
        this.domain = domain;
        this.mode = AuthMode.AuthByPassword;
    }

    public AuthArgs(String entity, RSAPrivateKey privateKey) {
        if (entity == null || privateKey == null) {
            throw new IllegalArgumentException("Entidade e chave privada devem ser diferentes de nulo.");
        }
        this.entity = entity;
        this.privkey = privateKey;
        this.mode = AuthMode.AuthByPrivateKey;
    }

    public AuthArgs(SharedAuthSecret secret) {
        if (secret == null) {
            throw new IllegalArgumentException("O segredo deve ser diferente de nulo.");
        }
        this.secret = secret;
        this.mode = AuthMode.AuthBySharedSecret;
    }

    static enum AuthMode {
        AuthByPassword,
        AuthByPrivateKey,
        AuthBySharedSecret;

    }
}

