/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NO_PERMISSIONHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;
import tecgraf.openbus.Connection;
import tecgraf.openbus.core.CallerChainImpl;
import tecgraf.openbus.core.ChainCacheKey;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.Credential;
import tecgraf.openbus.core.EffectiveProfile;
import tecgraf.openbus.core.InterceptorImpl;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.OpenBusContextImpl;
import tecgraf.openbus.core.Session;
import tecgraf.openbus.core.v2_0.credential.CredentialData;
import tecgraf.openbus.core.v2_0.credential.CredentialResetHelper;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_1.credential.CredentialReset;
import tecgraf.openbus.core.v2_1.credential.SignedData;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfoHolder;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.interceptors.CallChainInfo;
import tecgraf.openbus.interceptors.CallChainInfoHelper;
import tecgraf.openbus.security.Cryptography;

final class ClientRequestInterceptorImpl
extends InterceptorImpl
implements ClientRequestInterceptor {
    private static final Logger logger = Logger.getLogger(ClientRequestInterceptorImpl.class.getName());
    private final Map<Integer, ConnectionImpl> uniqueId2Conn = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, String> uniqueId2LoginId = Collections.synchronizedMap(new HashMap());

    ClientRequestInterceptorImpl(String name, ORBMediator mediator) {
        super(name, mediator);
    }

    private boolean checkSlotIdFlag(ClientRequestInfo ri, int slotId) {
        try {
            Any any = ri.get_slot(slotId);
            if (any.type().kind().value() != 0) {
                return any.extract_boolean();
            }
            return false;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar slot";
            throw new INTERNAL(message);
        }
    }

    @Override
    public void send_request(ClientRequestInfo ri) {
        String operation = ri.operation();
        if (this.checkSlotIdFlag(ri, this.context().getIgnoreThreadSlotId())) {
            logger.finest(String.format("Realizando chamada fora do barramento: opera\u00e7\u00e3o (%s)", operation));
            return;
        }
        ConnectionImpl conn = (ConnectionImpl)this.getCurrentConnection(ri);
        LoginInfo currLogin = conn.getLogin();
        if (currLogin == null) {
            String message = String.format("Chamada cancelada. Conex\u00e3o n\u00e3o possui login. opera\u00e7\u00e3o (%s)", operation);
            logger.info(message);
            throw new NO_PERMISSION(message, 1112888319, CompletionStatus.COMPLETED_NO);
        }
        LoginInfoHolder holder = new LoginInfoHolder();
        holder.value = currLogin;
        try {
            Credential credential = this.generateCredential(ri, conn, holder);
            if (credential.legacy != null) {
                ri.add_request_service_context(credential.toServiceContext(this.orb(), this.codec()), false);
            } else {
                Credential curr = new Credential(new tecgraf.openbus.core.v2_1.credential.CredentialData(credential.bus, credential.login, credential.session, credential.ticket, credential.hash, NULL_SIGNED_CALL_CHAIN));
                ri.add_request_service_context(curr.toServiceContext(this.orb(), this.codec()), false);
                if (conn.legacy()) {
                    Credential legacy = new Credential(new CredentialData(credential.bus, credential.login, credential.session, credential.ticket, credential.hash, NULL_SIGNED_LEGACY_CALL_CHAIN));
                    ri.add_request_service_context(legacy.toServiceContext(this.orb(), this.codec()), false);
                }
            }
        }
        catch (InvalidTypeForEncoding e) {
            String message = "Falha ao codificar a credencial ";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        int uniqueId = this.mediator().getUniqueId();
        Any uniqueAny = this.orb().create_any();
        uniqueAny.insert_long(uniqueId);
        try {
            Current current = ORBUtils.getPICurrent(this.orb());
            current.set_slot(this.mediator().getUniqueIdSlot(), uniqueAny);
            this.uniqueId2Conn.put(uniqueId, conn);
            this.uniqueId2LoginId.put(uniqueId, currLogin.id);
            logger.finest(String.format("associando o ID '%d' com o login '%s'. opera\u00e7\u00e3o (%s)", uniqueId, holder.value.id, operation));
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot de uniqueId";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    private Credential generateCredential(ClientRequestInfo ri, ConnectionImpl conn, LoginInfoHolder holder) {
        Session.ClientSideSession session;
        String operation = ri.operation();
        String bus = conn.busId();
        EffectiveProfile ep = new EffectiveProfile(ri.effective_profile());
        String targetId = conn.cache.entities.get(ep);
        if (targetId != null && (session = conn.cache.cltSessions.get(targetId)) != null) {
            Credential.Chain chain = this.getCallChain(ri, conn, holder, targetId, session);
            boolean isLegacy = chain.isLegacy();
            int ticket = session.nextTicket();
            byte[] credentialDataHash = this.generateCredentialDataHash(ri, session.getSecret(), ticket, isLegacy);
            logger.finest(String.format("utilizando sess\u00e3o: id = %d ticket = %d", session.getSession(), ticket));
            logger.fine(String.format("Realizando chamada via barramento: target (%s) opera\u00e7\u00e3o (%s)", targetId, operation));
            return new Credential(bus, holder.value.id, session.getSession(), ticket, credentialDataHash, chain, isLegacy);
        }
        logger.finest(String.format("Realizando chamada sem credencial: login (%s) opera\u00e7\u00e3o (%s)", holder.value.id, operation));
        return new Credential(bus, holder.value.id, 0, 0, NULL_HASH_VALUE, null, null);
    }

    private Credential.Chain getCallChain(ClientRequestInfo ri, ConnectionImpl conn, LoginInfoHolder holder, String target, Session.ClientSideSession session) {
        Credential.Chain joined = this.getJoinedChain(ri);
        if (target.equals("00000000-0000-0000-0000-000000000000")) {
            return joined;
        }
        try {
            String entity = session.getEntity();
            boolean legacy = session.legacy();
            LoginInfo curr = holder.value;
            ChainCacheKey key = new ChainCacheKey(entity, joined.signature(), legacy);
            Credential.Chain chain = conn.cache.chains.get(key);
            if (chain == null) {
                if (legacy) {
                    SignedCallChain chainFor;
                    do {
                        chainFor = conn.legacySupport().access().signChainFor(target);
                        curr = conn.getLogin();
                    } while (!this.decodeSignedLegacyChain((SignedCallChain)chainFor).caller.id.equals(curr.id));
                    chain = new Credential.Chain(chainFor);
                    chain.updateInfos(conn.busId(), this.decodeSignedLegacyChain(chainFor));
                    conn.cache.chains.put(key, chain);
                } else {
                    SignedData chainFor;
                    if (joined.isLegacy() && !conn.legacy()) {
                        String error = "n\u00e3o \u00e9 poss\u00edvel unir-se a cadeia legada";
                        logger.log(Level.SEVERE, error);
                        throw new NO_PERMISSION(error, 1112888065, CompletionStatus.COMPLETED_NO);
                    }
                    do {
                        chainFor = conn.access().signChainFor(entity);
                        curr = conn.getLogin();
                    } while (!this.decodeSignedChain((SignedData)chainFor).caller.id.equals(curr.id));
                    chain = new Credential.Chain(chainFor);
                    chain.updateInfos(this.decodeSignedChain(chainFor));
                    conn.cache.chains.put(key, chain);
                }
            }
            holder.value = curr;
            return chain;
        }
        catch (InvalidLogins e) {
            Map<EffectiveProfile, String> cache = conn.cache.entities;
            ArrayList<EffectiveProfile> toRemove = new ArrayList<EffectiveProfile>();
            for (Map.Entry<EffectiveProfile, String> entry : cache.entrySet()) {
                if (!target.equals(entry.getValue())) continue;
                toRemove.add(entry.getKey());
            }
            for (EffectiveProfile ep : toRemove) {
                cache.remove(ep);
            }
            String message = String.format("Erro ao assinar cadeia para target: (%s)", e.loginIds[0]);
            logger.log(Level.SEVERE, message, e);
            throw new NO_PERMISSION(message, 1112888316, CompletionStatus.COMPLETED_NO);
        }
        catch (SystemException e) {
            String message = String.format("Erro durante acesso ao barramento (%s).", conn.busId());
            logger.log(Level.SEVERE, message, e);
            throw new NO_PERMISSION(message, 1112888317, CompletionStatus.COMPLETED_NO);
        }
        catch (ServiceFailure e) {
            String message = String.format("Falha inesperada ao assinar uma cadeia de chamadas: target (%s)", target);
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar cadeia";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    private tecgraf.openbus.core.v2_1.services.access_control.CallChain decodeSignedChain(SignedData data) throws FormatMismatch, TypeMismatch {
        Any any = this.codec().decode_value(data.encoded, tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.type());
        return tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.extract(any);
    }

    private CallChain decodeSignedLegacyChain(SignedCallChain data) throws FormatMismatch, TypeMismatch {
        Any any = this.codec().decode_value(data.encoded, CallChainHelper.type());
        return CallChainHelper.extract(any);
    }

    private Credential.Chain getJoinedChain(ClientRequestInfo ri) {
        Credential.Chain chain;
        try {
            Any any = ri.get_slot(this.mediator().getJoinedChainSlotId());
            if (any.type().kind().value() != 0) {
                CallChainInfo info = CallChainInfoHelper.extract(any);
                CallerChainImpl callerChain = CallerChainImpl.info2CallerChain(info, this.codec());
                chain = callerChain.internal_chain();
            } else {
                chain = new Credential.Chain(NULL_SIGNED_CALL_CHAIN);
            }
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot do JoinedChain";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar cadeia";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        return chain;
    }

    @Override
    public void send_poll(ClientRequestInfo ri) {
        logger.finest(String.format("[inout] send_pool: %s", ri.operation()));
    }

    @Override
    public void receive_reply(ClientRequestInfo ri) {
        String operation = ri.operation();
        logger.finest(String.format("[in] receive_reply: %s", operation));
        if (!this.checkSlotIdFlag(ri, this.context().getIgnoreThreadSlotId())) {
            this.clearRequestUniqueId();
            logger.fine(String.format("requisi\u00e7\u00e3o atendida com sucesso: opera\u00e7\u00e3o (%s)", ri.operation()));
        }
        logger.finest(String.format("[out] receive_reply: %s", operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        try {
            logger.finest(String.format("Exception: %s Request: %s", ri.received_exception_id(), ri.operation()));
            if (!ri.received_exception_id().equals(NO_PERMISSIONHelper.id())) {
                return;
            }
            Any exceptionAny = ri.received_exception();
            NO_PERMISSION exception = NO_PERMISSIONHelper.extract(exceptionAny);
            if (!exception.completed.equals(CompletionStatus.COMPLETED_NO)) {
                return;
            }
            Integer uniqueId = this.getRequestUniqueId();
            ConnectionImpl conn = this.uniqueId2Conn.get(uniqueId);
            String loginId = this.uniqueId2LoginId.get(uniqueId);
            switch (exception.minor) {
                case 1112888064: {
                    byte[] secret;
                    if (conn == null || loginId == null) {
                        String message = "Faltam informa\u00e7\u00f5es associadas a requisi\u00e7\u00e3o";
                        logger.log(Level.SEVERE, message);
                        throw new INTERNAL(message);
                    }
                    EffectiveProfile ep = new EffectiveProfile(ri.effective_profile());
                    Credential.Reset reset = this.getCredentialReset(ri, conn.legacy());
                    if (reset == null) {
                        String message = "Servidor n\u00e3o enviou o CredentialReset para negociar sess\u00e3o)";
                        logger.info(message);
                        throw new NO_PERMISSION(message, 1112888318, CompletionStatus.COMPLETED_NO);
                    }
                    Cryptography crypto = Cryptography.getInstance();
                    try {
                        secret = crypto.decrypt(reset.challenge, conn.getPrivateKey());
                    }
                    catch (CryptographyException e) {
                        String message = "Falha inesperada ao descriptografar segredo.";
                        logger.log(Level.SEVERE, message, e);
                        throw new NO_PERMISSION(message, 1112888318, CompletionStatus.COMPLETED_NO);
                    }
                    conn.cache.entities.put(ep, reset.target);
                    conn.cache.cltSessions.put(reset.target, new Session.ClientSideSession(reset, secret));
                    logger.finest(String.format("ForwardRequest: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                    throw new ForwardRequest(ri.target());
                }
                case 1112888066: {
                    boolean skipInvLogin = this.checkSlotIdFlag(ri, this.context().getSkipInvalidLoginSlotId());
                    if (skipInvLogin) return;
                    if (conn == null || loginId == null) {
                        String message = "Faltam informa\u00e7\u00f5es associadas a requisi\u00e7\u00e3o";
                        logger.log(Level.SEVERE, message);
                        throw new INTERNAL(message);
                    }
                    int validity = 0;
                    try {
                        this.context().ignoreInvLogin();
                        validity = this.context().getLoginRegistry().getLoginValidity(loginId);
                    }
                    catch (NO_PERMISSION e) {
                        if (e.minor != 1112888066) {
                            String msg = String.format("Erro em valida\u00e7\u00e3o de login: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation());
                            logger.log(Level.SEVERE, msg, e);
                            throw new NO_PERMISSION(msg, 1112888317, CompletionStatus.COMPLETED_NO);
                        }
                        LoginInfo curr = conn.login();
                        if (curr != null && curr.id.equals(loginId)) {
                            conn.localLogout(true);
                        }
                        logger.finest(String.format("ForwardRequest: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                        throw new ForwardRequest(ri.target());
                    }
                    catch (Exception e) {
                        String msg = String.format("Erro em valida\u00e7\u00e3o de login: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation());
                        logger.log(Level.SEVERE, msg, e);
                        throw new NO_PERMISSION(msg, 1112888317, CompletionStatus.COMPLETED_NO);
                    }
                    finally {
                        this.context().unignoreInvLogin();
                    }
                    if (validity > 0) {
                        String msg = String.format("InvalidLogin equivocado: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation());
                        logger.info(msg);
                        throw new NO_PERMISSION(msg, 1112888318, CompletionStatus.COMPLETED_NO);
                    }
                    logger.finest(String.format("ForwardRequest: login (%s) opera\u00e7\u00e3o (%s)", loginId, ri.operation()));
                    throw new ForwardRequest(ri.target());
                }
                case 1112888316: 
                case 1112888317: 
                case 1112888318: 
                case 1112888319: {
                    String message = "Servidor repassou uma exce\u00e7\u00e3o NO_PERMISSION local: minor = %d";
                    String msg = String.format(message, exception.minor);
                    logger.log(Level.WARNING, msg, exception);
                    throw new NO_PERMISSION(msg, 1112888318, CompletionStatus.COMPLETED_NO);
                }
                case 1112888070: {
                    return;
                }
            }
            return;
        }
        finally {
            this.clearRequestUniqueId();
        }
    }

    private Credential.Reset getCredentialReset(ClientRequestInfo ri, boolean legacy) {
        block9: {
            try {
                Any any;
                byte[] context_data;
                block10: {
                    ServiceContext context;
                    block8: {
                        context_data = null;
                        try {
                            context = ri.get_reply_service_context(1112888065);
                            context_data = context.context_data;
                        }
                        catch (BAD_PARAM e) {
                            if (e.minor == 26) break block8;
                            throw e;
                        }
                    }
                    if (context_data != null) {
                        any = this.codec().decode_value(context_data, tecgraf.openbus.core.v2_1.credential.CredentialResetHelper.type());
                        CredentialReset creset = tecgraf.openbus.core.v2_1.credential.CredentialResetHelper.extract(any);
                        return new Credential.Reset(new LoginInfo(creset.target, creset.entity), creset.session, creset.challenge, false);
                    }
                    if (!legacy) break block9;
                    try {
                        context = ri.get_reply_service_context(1112888064);
                        context_data = context.context_data;
                    }
                    catch (BAD_PARAM e) {
                        if (e.minor == 26) break block10;
                        throw e;
                    }
                }
                if (context_data != null) {
                    any = this.codec().decode_value(context_data, CredentialResetHelper.type());
                    tecgraf.openbus.core.v2_0.credential.CredentialReset creset = CredentialResetHelper.extract(any);
                    return new Credential.Reset(new LoginInfo(creset.target, null), creset.session, creset.challenge, true);
                }
            }
            catch (FormatMismatch | TypeMismatch e) {
                String message = "Falha inesperada ao obter o CredentialReset";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
        }
        return null;
    }

    private Integer getRequestUniqueId() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb());
            Any uniqueAny = current.get_slot(this.mediator().getUniqueIdSlot());
            if (uniqueAny.type().kind().value() != 0) {
                return uniqueAny.extract_long();
            }
            String message = "Any de chave \u00fanica de requestId est\u00e1 vazia!";
            logger.fine(message);
            return null;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot do request Id";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
    }

    private void clearRequestUniqueId() {
        Integer uniqueId = this.getRequestUniqueId();
        if (uniqueId != null) {
            this.uniqueId2Conn.remove(uniqueId);
            this.uniqueId2LoginId.remove(uniqueId);
            try {
                ORB orb = this.orb();
                Any emptyAny = orb.create_any();
                Current current = ORBUtils.getPICurrent(orb);
                current.set_slot(this.mediator().getUniqueIdSlot(), emptyAny);
            }
            catch (InvalidSlot e) {
                String message = "Falha inesperada ao acessar o slot de requestId";
                logger.log(Level.SEVERE, message, e);
                throw new INTERNAL(message);
            }
        }
    }

    private Connection getCurrentConnection(RequestInfo ri) {
        int id;
        Connection connection;
        Any any;
        OpenBusContextImpl context = this.mediator().getContext();
        try {
            any = ri.get_slot(context.getCurrentConnectionSlotId());
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot da conex\u00e3o corrente";
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0 && (connection = context.getConnectionById(id = any.extract_long())) != null) {
            return connection;
        }
        Connection connection2 = context.defaultConnection();
        if (connection2 != null) {
            return connection2;
        }
        throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
    }

    @Override
    public void receive_other(ClientRequestInfo ri) {
        logger.finest(String.format("[inout] receive_other: %s", ri.operation()));
    }
}

